/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import com.google.common.base.Strings;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

@ScalarFunction(value="human_readable_seconds")
public final class HumanReadableSeconds {
    private static final int DAYS_IN_WEEK = 7;
    private static final int SECONDS_IN_WEEK = 604800;
    private static final String WEEK = "week";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";

    private HumanReadableSeconds() {
    }

    @SqlNullable
    @SqlType(value="varchar")
    public static Slice humanReadableSeconds(@SqlType(value="double") double inputSeconds) {
        if (Double.isNaN(inputSeconds) || Double.isInfinite(inputSeconds)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid argument found: %s", inputSeconds));
        }
        long seconds = Math.round(Math.abs(inputSeconds));
        long weeks = TimeUnit.SECONDS.toDays(seconds) / 7L;
        long days = TimeUnit.SECONDS.toDays(seconds %= 604800L);
        long hours = TimeUnit.SECONDS.toHours(seconds %= 86400L);
        long minutes = TimeUnit.SECONDS.toMinutes(seconds %= 3600L);
        return HumanReadableSeconds.getTimePeriods(weeks, days, hours, minutes, seconds %= 60L);
    }

    private static Slice getTimePeriods(long weeks, long days, long hours, long minutes, long seconds) {
        String timePeriod;
        StringJoiner stringJoiner = new StringJoiner(", ");
        if (weeks > 0L) {
            stringJoiner.add(HumanReadableSeconds.renderPeriodType(weeks, WEEK));
        }
        if (days > 0L) {
            stringJoiner.add(HumanReadableSeconds.renderPeriodType(days, DAY));
        }
        if (hours > 0L) {
            stringJoiner.add(HumanReadableSeconds.renderPeriodType(hours, HOUR));
        }
        if (minutes > 0L) {
            stringJoiner.add(HumanReadableSeconds.renderPeriodType(minutes, MINUTE));
        }
        if (seconds > 0L) {
            stringJoiner.add(HumanReadableSeconds.renderPeriodType(seconds, SECOND));
        }
        if (Strings.isNullOrEmpty((String)(timePeriod = stringJoiner.toString()))) {
            return Slices.utf8Slice((String)HumanReadableSeconds.renderPeriodType(0L, SECOND));
        }
        return Slices.utf8Slice((String)timePeriod);
    }

    private static String renderPeriodType(long value, String periodType) {
        if (value == 1L) {
            return value + " " + periodType;
        }
        return value + " " + periodType + "s";
    }
}

