/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.trino.client.NodeVersion;
import io.trino.client.ServerInfo;
import io.trino.metadata.NodeState;
import io.trino.server.NodeStateManager;
import io.trino.server.ServerConfig;
import io.trino.server.StartupStatus;
import io.trino.server.security.ResourceSecurity;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;

@Path(value="/v1/info")
public class ServerInfoResource {
    private static final Logger log = Logger.get(ServerInfoResource.class);
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final NodeStateManager nodeStateManager;
    private final StartupStatus startupStatus;
    private final long startTime = System.nanoTime();

    @Inject
    public ServerInfoResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, NodeStateManager nodeStateManager, StartupStatus startupStatus) {
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = nodeInfo.getEnvironment();
        this.coordinator = serverConfig.isCoordinator();
        this.nodeStateManager = Objects.requireNonNull(nodeStateManager, "nodeStateManager is null");
        this.startupStatus = Objects.requireNonNull(startupStatus, "startupStatus is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"application/json"})
    public ServerInfo getInfo() {
        boolean starting = !this.startupStatus.isStartupComplete();
        return new ServerInfo(this.version, this.environment, this.coordinator, starting, Optional.of(Duration.nanosSince((long)this.startTime)));
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_WRITE)
    @PUT
    @Path(value="state")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response updateState(NodeState state) {
        Objects.requireNonNull(state, "state is null");
        log.info("Worker State change requested: %s -> %s", new Object[]{this.nodeStateManager.getServerState().toString(), state.toString()});
        try {
            this.nodeStateManager.transitionState(state);
            return Response.ok().build();
        }
        catch (IllegalStateException e) {
            throw new BadRequestException(String.format("Invalid state transition to %s", new Object[]{state}));
        }
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="state")
    @Produces(value={"application/json"})
    public NodeState getServerState() {
        return this.nodeStateManager.getServerState();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="coordinator")
    @Produces(value={"text/plain"})
    public Response getServerCoordinator() {
        if (this.coordinator) {
            return Response.ok().build();
        }
        throw new NotFoundException();
    }
}

