/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;

@DefunctConfig(value={"http.server.authentication.enabled", "http-server.authentication.allow-forwarded-https", "dispatcher.forwarded-header"})
public class SecurityConfig {
    private boolean insecureAuthenticationOverHttpAllowed = true;
    private List<String> authenticationTypes = ImmutableList.of((Object)"insecure");
    private Optional<String> fixedManagementUser = Optional.empty();
    private boolean fixedManagementUserForHttps;

    public boolean isInsecureAuthenticationOverHttpAllowed() {
        return this.insecureAuthenticationOverHttpAllowed;
    }

    @Config(value="http-server.authentication.allow-insecure-over-http")
    @ConfigDescription(value="Insecure authentication over HTTP (non-secure) enabled")
    public SecurityConfig setInsecureAuthenticationOverHttpAllowed(boolean insecureAuthenticationOverHttpAllowed) {
        this.insecureAuthenticationOverHttpAllowed = insecureAuthenticationOverHttpAllowed;
        return this;
    }

    @NotNull
    @NotEmpty(message="http-server.authentication.type cannot be empty")
    public @NotNull @NotEmpty(message="http-server.authentication.type cannot be empty") List<String> getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    @Config(value="http-server.authentication.type")
    @ConfigDescription(value="Ordered list of authentication types")
    public SecurityConfig setAuthenticationTypes(List<String> types) {
        this.authenticationTypes = ImmutableList.copyOf(types);
        return this;
    }

    public Optional<String> getFixedManagementUser() {
        return this.fixedManagementUser;
    }

    @Config(value="management.user")
    @ConfigDescription(value="Optional fixed user for all requests to management endpoints")
    public SecurityConfig setFixedManagementUser(String fixedManagementUser) {
        this.fixedManagementUser = Optional.ofNullable(fixedManagementUser);
        return this;
    }

    public boolean isFixedManagementUserForHttps() {
        return this.fixedManagementUserForHttps;
    }

    @Config(value="management.user.https-enabled")
    @ConfigDescription(value="Use fixed management user for secure HTTPS requests")
    public SecurityConfig setFixedManagementUserForHttps(boolean fixedManagementUserForHttps) {
        this.fixedManagementUserForHttps = fixedManagementUserForHttps;
        return this;
    }
}

