/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.trino.server.security.oauth2.ChallengeFailedException;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2TokenExchange;
import io.trino.server.security.oauth2.OAuth2TokenHandler;
import io.trino.server.security.oauth2.TokenPairSerializer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class TokenRefresher {
    private final TokenPairSerializer tokenAssembler;
    private final OAuth2TokenHandler tokenHandler;
    private final OAuth2Client client;

    public TokenRefresher(TokenPairSerializer tokenAssembler, OAuth2TokenHandler tokenHandler, OAuth2Client client) {
        this.tokenAssembler = Objects.requireNonNull(tokenAssembler, "tokenAssembler is null");
        this.tokenHandler = Objects.requireNonNull(tokenHandler, "tokenHandler is null");
        this.client = Objects.requireNonNull(client, "oAuth2Client is null");
    }

    public Optional<UUID> refreshToken(TokenPairSerializer.TokenPair tokenPair) {
        Objects.requireNonNull(tokenPair, "tokenPair is null");
        Optional<String> refreshToken = tokenPair.refreshToken();
        if (refreshToken.isPresent()) {
            UUID refreshingId = UUID.randomUUID();
            try {
                this.refreshToken(refreshToken.get(), refreshingId);
                return Optional.of(refreshingId);
            }
            catch (RuntimeException exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private void refreshToken(String refreshToken, UUID refreshingId) {
        try {
            OAuth2Client.Response response = this.client.refreshTokens(refreshToken);
            String serializedToken = this.tokenAssembler.serialize(TokenPairSerializer.TokenPair.fromOAuth2Response(response));
            this.tokenHandler.setAccessToken(OAuth2TokenExchange.hashAuthId(refreshingId), serializedToken);
        }
        catch (ChallengeFailedException e) {
            this.tokenHandler.setTokenExchangeError(OAuth2TokenExchange.hashAuthId(refreshingId), "Token refreshing has failed: " + e.getMessage());
        }
    }
}

