/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.trino.server.security.SecurityConfig;
import io.trino.server.ui.FixedUserPreviewResource;
import io.trino.server.ui.LoginPreviewResource;
import io.trino.server.ui.OAuth2WebUiPreviewResource;
import io.trino.server.ui.WebUiAuthenticationConfig;
import io.trino.server.ui.WebUiPreviewStaticResource;
import java.util.List;
import java.util.Locale;

public class WebUiPreviewModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        String authentication;
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WebUiPreviewStaticResource.class);
        switch (authentication = this.getAuthenticationType()) {
            case "insecure": 
            case "form": 
            case "jwt": 
            case "kerberos": 
            case "certificate": {
                JaxrsBinder.jaxrsBinder((Binder)binder).bind(LoginPreviewResource.class);
                break;
            }
            case "fixed": {
                JaxrsBinder.jaxrsBinder((Binder)binder).bind(FixedUserPreviewResource.class);
                break;
            }
            case "oauth2": {
                JaxrsBinder.jaxrsBinder((Binder)binder).bind(OAuth2WebUiPreviewResource.class);
                break;
            }
            case "none": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown authentication type: " + authentication);
            }
        }
    }

    private String getAuthenticationType() {
        String authentication = ((WebUiAuthenticationConfig)this.buildConfigObject(WebUiAuthenticationConfig.class)).getAuthentication();
        if (authentication != null) {
            return authentication.toLowerCase(Locale.ENGLISH);
        }
        List authenticationTypes = (List)((SecurityConfig)this.buildConfigObject(SecurityConfig.class)).getAuthenticationTypes().stream().map(type -> type.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
        if (authenticationTypes.contains("password")) {
            return "form";
        }
        return (String)authenticationTypes.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("authenticatorTypes is empty"));
    }
}

