/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Lambda;
import io.trino.sql.planner.Symbol;
import io.trino.type.FunctionType;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonSerialize
public record Bind(List<Expression> values, Lambda function) implements Expression
{
    public Bind {
        values = ImmutableList.copyOf(values);
        for (int i = 0; i < values.size(); ++i) {
            IrUtils.validateType(function.arguments().get(i).type(), (Expression)values.get(i));
        }
    }

    @Override
    public Type type() {
        return new FunctionType((List)this.function.arguments().subList(this.values.size(), this.function.arguments().size()).stream().map(Symbol::type).collect(ImmutableList.toImmutableList()), ((FunctionType)this.function.type()).getReturnType());
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitBind(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.builder().addAll(this.values).add((Object)this.function).build();
    }

    @Override
    public String toString() {
        return "Bind(%s, %s)".formatted(this.function, this.values.stream().map((Function<Expression, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/trino/sql/ir/Expression;)Ljava/lang/String;)()).collect(Collectors.joining(", ")));
    }
}

