/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SimplifyComplementaryLogicalTerms
implements IrOptimizerRule {
    private final Metadata metadata;

    public SimplifyComplementaryLogicalTerms(PlannerContext context) {
        this.metadata = context.getMetadata();
    }

    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Logical)) {
            return Optional.empty();
        }
        Logical logical = (Logical)expression;
        HashSet<Expression> positives = new HashSet<Expression>();
        HashSet<Expression> negatives = new HashSet<Expression>();
        for (Expression term : logical.terms()) {
            Call not;
            if (!DeterminismEvaluator.isDeterministic(term)) continue;
            if (term instanceof Call && (not = (Call)term).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$not"))) {
                negatives.add(not.arguments().getFirst());
                continue;
            }
            positives.add(term);
        }
        if (negatives.isEmpty() || positives.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<Expression> newTerms = new ArrayList<Expression>();
        HashSet<Expression> seen = new HashSet<Expression>();
        boolean changed = false;
        for (Expression term : logical.terms()) {
            if (DeterminismEvaluator.isDeterministic(term)) {
                Call not;
                Expression unwrapped = term;
                if (term instanceof Call && (not = (Call)term).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("$not"))) {
                    unwrapped = not.arguments().getFirst();
                }
                if (positives.contains(unwrapped) && negatives.contains(unwrapped)) {
                    if (seen.contains(unwrapped)) continue;
                    changed = true;
                    newTerms.add(switch (logical.operator()) {
                        default -> throw new MatchException(null, null);
                        case Logical.Operator.AND -> new Logical(Logical.Operator.AND, (List<Expression>)ImmutableList.of((Object)unwrapped, (Object)new IsNull(unwrapped)));
                        case Logical.Operator.OR -> new Logical(Logical.Operator.OR, (List<Expression>)ImmutableList.of((Object)unwrapped, (Object)IrExpressions.not(this.metadata, new IsNull(unwrapped))));
                    });
                    seen.add(unwrapped);
                    continue;
                }
                newTerms.add(term);
                continue;
            }
            newTerms.add(term);
        }
        if (!changed) {
            return Optional.empty();
        }
        if (newTerms.size() == 1) {
            return Optional.of((Expression)newTerms.getFirst());
        }
        return Optional.of(new Logical(logical.operator(), newTerms));
    }
}

