/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.Objects;
import java.util.Optional;

public class PartitioningHandle {
    private final Optional<CatalogHandle> catalogHandle;
    private final Optional<ConnectorTransactionHandle> transactionHandle;
    private final ConnectorPartitioningHandle connectorHandle;
    private final boolean scaleWriters;

    public static boolean isScaledWriterHashDistribution(PartitioningHandle partitioning) {
        return partitioning.isScaleWriters() && (partitioning.equals(SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION) || partitioning.getCatalogHandle().isPresent());
    }

    public PartitioningHandle(Optional<CatalogHandle> catalogHandle, Optional<ConnectorTransactionHandle> transactionHandle, ConnectorPartitioningHandle connectorHandle) {
        this(catalogHandle, transactionHandle, connectorHandle, false);
    }

    @JsonCreator
    public PartitioningHandle(@JsonProperty(value="catalogHandle") Optional<CatalogHandle> catalogHandle, @JsonProperty(value="transactionHandle") Optional<ConnectorTransactionHandle> transactionHandle, @JsonProperty(value="connectorHandle") ConnectorPartitioningHandle connectorHandle, @JsonProperty(value="scaleWriters") boolean scaleWriters) {
        this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        Preconditions.checkArgument((catalogHandle.isEmpty() || transactionHandle.isPresent() ? 1 : 0) != 0, (Object)"transactionHandle is required when catalogHandle is present");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
        this.scaleWriters = scaleWriters;
    }

    @JsonProperty
    public Optional<CatalogHandle> getCatalogHandle() {
        return this.catalogHandle;
    }

    @JsonProperty
    public Optional<ConnectorTransactionHandle> getTransactionHandle() {
        return this.transactionHandle;
    }

    @JsonProperty
    public ConnectorPartitioningHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    @JsonProperty
    public boolean isScaleWriters() {
        return this.scaleWriters;
    }

    public boolean isSingleNode() {
        return this.connectorHandle.isSingleNode();
    }

    public boolean isCoordinatorOnly() {
        return this.connectorHandle.isCoordinatorOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningHandle that = (PartitioningHandle)o;
        return Objects.equals(this.catalogHandle, that.catalogHandle) && Objects.equals(this.transactionHandle, that.transactionHandle) && Objects.equals(this.connectorHandle, that.connectorHandle) && this.scaleWriters == that.scaleWriters;
    }

    public int hashCode() {
        return Objects.hash(this.catalogHandle, this.transactionHandle, this.connectorHandle, this.scaleWriters);
    }

    public String toString() {
        Object result = this.connectorHandle.toString();
        if (this.scaleWriters) {
            result = (String)result + " (scale writers)";
        }
        if (this.catalogHandle.isPresent()) {
            result = String.valueOf(this.catalogHandle.get()) + ":" + (String)result;
        }
        return result;
    }
}

