/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.QueryPreparer;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.QueryUtil;
import io.trino.sql.SessionPropertyResolver;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainer;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ExplainRewrite
implements StatementRewrite.Rewrite {
    private final QueryExplainerFactory queryExplainerFactory;
    private final SessionPropertyResolver sessionPropertyResolver;
    private final QueryPreparer queryPreparer;

    @Inject
    public ExplainRewrite(QueryExplainerFactory queryExplainerFactory, SessionPropertyResolver sessionPropertyResolver, QueryPreparer queryPreparer) {
        this.queryExplainerFactory = Objects.requireNonNull(queryExplainerFactory, "queryExplainerFactory is null");
        this.sessionPropertyResolver = Objects.requireNonNull(sessionPropertyResolver, "sessionPropertyResolver is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
    }

    @Override
    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameter, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return (Statement)new Visitor(session, this.sessionPropertyResolver, this.queryPreparer, this.queryExplainerFactory.createQueryExplainer(analyzerFactory), warningCollector, planOptimizersStatsCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SessionPropertyResolver sessionPropertyResolver;
        private final QueryPreparer queryPreparer;
        private final QueryExplainer queryExplainer;
        private final WarningCollector warningCollector;
        private final PlanOptimizersStatsCollector planOptimizersStatsCollector;

        public Visitor(Session session, SessionPropertyResolver sessionPropertyResolver, QueryPreparer queryPreparer, QueryExplainer queryExplainer, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.sessionPropertyResolver = Objects.requireNonNull(sessionPropertyResolver, "sessionPropertyResolver is null");
            this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.planOptimizersStatsCollector = planOptimizersStatsCollector;
        }

        protected Node visitExplainAnalyze(ExplainAnalyze node, Void context) {
            Statement statement = (Statement)this.process((Node)node.getStatement(), context);
            return new ExplainAnalyze((NodeLocation)node.getLocation().orElseThrow(), statement, node.isVerbose());
        }

        protected Node visitExplain(Explain node, Void context) {
            ExplainType.Type planType = ExplainType.Type.DISTRIBUTED;
            ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
            List options = node.getOptions();
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainType)) continue;
                ExplainType explainType = (ExplainType)option;
                planType = explainType.getType();
                if (planType != ExplainType.Type.IO) break;
                planFormat = ExplainFormat.Type.JSON;
                break;
            }
            for (ExplainOption option : options) {
                if (!(option instanceof ExplainFormat)) continue;
                ExplainFormat explainFormat = (ExplainFormat)option;
                planFormat = explainFormat.getType();
                break;
            }
            return this.getQueryPlan(node, planType, planFormat);
        }

        private Node getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
            QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(this.session, node.getStatement());
            Session resolvedSession = (Session)this.sessionPropertyResolver.getSessionPropertiesApplier(preparedQuery).apply(this.session);
            if (planType == ExplainType.Type.VALIDATE) {
                this.queryExplainer.validate(resolvedSession, preparedQuery.getStatement(), preparedQuery.getParameters(), this.warningCollector, this.planOptimizersStatsCollector);
                return QueryUtil.singleValueQuery((String)"Valid", (boolean)true);
            }
            String plan = switch (planFormat) {
                default -> throw new MatchException(null, null);
                case ExplainFormat.Type.GRAPHVIZ -> this.queryExplainer.getGraphvizPlan(resolvedSession, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector, this.planOptimizersStatsCollector);
                case ExplainFormat.Type.JSON -> this.queryExplainer.getJsonPlan(resolvedSession, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector, this.planOptimizersStatsCollector);
                case ExplainFormat.Type.TEXT -> this.queryExplainer.getPlan(resolvedSession, preparedQuery.getStatement(), planType, preparedQuery.getParameters(), this.warningCollector, this.planOptimizersStatsCollector);
            };
            return QueryUtil.singleValueQuery((String)"Query Plan", (String)plan);
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

