/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import io.airlift.tracing.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.connector.ConnectorAwareNodeManager;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.testing.TestingHandles;
import io.trino.type.InternalTypeManager;
import io.trino.util.EmbedVersion;

public final class TestingConnectorContext
implements ConnectorContext {
    private final NodeManager nodeManager;
    private final VersionEmbedder versionEmbedder = new EmbedVersion("testversion");
    private final PageSorter pageSorter = new PagesIndexPageSorter(new PagesIndex.TestingFactory(false));
    private final PageIndexerFactory pageIndexerFactory = new GroupByHashPageIndexerFactory(new FlatHashStrategyCompiler(new TypeOperators()));

    public TestingConnectorContext() {
        this.nodeManager = new ConnectorAwareNodeManager(new InMemoryNodeManager(new InternalNode[0]), "testenv", TestingHandles.TEST_CATALOG_HANDLE, true);
    }

    public CatalogHandle getCatalogHandle() {
        return TestingHandles.TEST_CATALOG_HANDLE;
    }

    public OpenTelemetry getOpenTelemetry() {
        return OpenTelemetry.noop();
    }

    public Tracer getTracer() {
        return Tracing.noopTracer();
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public VersionEmbedder getVersionEmbedder() {
        return this.versionEmbedder;
    }

    public TypeManager getTypeManager() {
        return InternalTypeManager.TESTING_TYPE_MANAGER;
    }

    public MetadataProvider getMetadataProvider() {
        return MetadataProvider.NOOP_METADATA_PROVIDER;
    }

    public PageSorter getPageSorter() {
        return this.pageSorter;
    }

    public PageIndexerFactory getPageIndexerFactory() {
        return this.pageIndexerFactory;
    }
}

