/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateSchema
extends Statement {
    private final QualifiedName schemaName;
    private final boolean notExists;
    private final List<Property> properties;
    private final Optional<PrincipalSpecification> principal;

    public CreateSchema(NodeLocation location, QualifiedName schemaName, boolean notExists, List<Property> properties, Optional<PrincipalSpecification> principal) {
        super(location);
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.notExists = notExists;
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.principal = principal;
    }

    public QualifiedName getSchemaName() {
        return this.schemaName;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public Optional<PrincipalSpecification> getPrincipal() {
        return this.principal;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateSchema(this, context);
    }

    public List<Property> getChildren() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schemaName, this.notExists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateSchema o = (CreateSchema)obj;
        return Objects.equals(this.schemaName, o.schemaName) && this.notExists == o.notExists && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("notExists", this.notExists).add("properties", this.properties).toString();
    }
}

