/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RowPattern;
import java.util.List;
import java.util.Objects;

public class ExcludedPattern
extends RowPattern {
    private final RowPattern pattern;

    public ExcludedPattern(NodeLocation location, RowPattern pattern) {
        super(location);
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
    }

    public RowPattern getPattern() {
        return this.pattern;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExcludedPattern(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.pattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExcludedPattern o = (ExcludedPattern)obj;
        return Objects.equals(this.pattern, o.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return ExcludedPattern.sameClass(this, other);
    }
}

