/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;

public class GroupingOperation
extends Expression {
    private final List<Expression> groupingColumns;

    public GroupingOperation(NodeLocation location, List<QualifiedName> groupingColumns) {
        super(location);
        Objects.requireNonNull(groupingColumns);
        Preconditions.checkArgument((!groupingColumns.isEmpty() ? 1 : 0) != 0, (Object)"grouping operation columns cannot be empty");
        this.groupingColumns = (List)groupingColumns.stream().map(DereferenceExpression::from).collect(ImmutableList.toImmutableList());
    }

    public List<Expression> getGroupingColumns() {
        return this.groupingColumns;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingOperation(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.groupingColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingOperation other = (GroupingOperation)o;
        return Objects.equals(this.groupingColumns, other.groupingColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupingColumns);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return GroupingOperation.sameClass(this, other);
    }
}

