/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.faker.FakerColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record ColumnInfo(FakerColumnHandle handle, ColumnMetadata metadata) {
    public static final String NULL_PROBABILITY_PROPERTY = "null_probability";
    public static final String GENERATOR_PROPERTY = "generator";
    public static final String MIN_PROPERTY = "min";
    public static final String MAX_PROPERTY = "max";
    public static final String ALLOWED_VALUES_PROPERTY = "allowed_values";
    public static final String STEP_PROPERTY = "step";

    public ColumnInfo {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(metadata, "metadata is null");
    }

    public String name() {
        return this.metadata.getName();
    }

    public Type type() {
        return this.metadata.getType();
    }

    @Override
    public String toString() {
        return this.metadata.getName() + "::" + String.valueOf(this.metadata.getType());
    }

    public ColumnInfo withComment(Optional<String> comment) {
        return new ColumnInfo(this.handle, ColumnMetadata.builderFrom((ColumnMetadata)this.metadata).setComment(comment).build());
    }

    public ColumnInfo withHandle(FakerColumnHandle handle) {
        return new ColumnInfo(handle, this.metadata);
    }

    public ColumnInfo withProperties(Map<String, Object> properties) {
        return new ColumnInfo(this.handle, ColumnMetadata.builderFrom((ColumnMetadata)this.metadata).setProperties((Map)ImmutableMap.copyOf(properties)).build());
    }
}

