/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Locale;

public class FakerConfig {
    private double nullProbability = 0.5;
    private long defaultLimit = 1000L;
    private Locale locale = Locale.ENGLISH;
    private boolean sequenceDetectionEnabled = true;
    private boolean dictionaryDetectionEnabled = true;

    @Max(value=1L)
    @Min(value=0L)
    public @Max(value=1L) @Min(value=0L) double getNullProbability() {
        return this.nullProbability;
    }

    @Config(value="faker.null-probability")
    @ConfigDescription(value="Default null probability for any column in any table that allows them")
    public FakerConfig setNullProbability(double value) {
        this.nullProbability = value;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getDefaultLimit() {
        return this.defaultLimit;
    }

    @Config(value="faker.default-limit")
    @ConfigDescription(value="Default number of rows for each table, when the LIMIT clause is not specified in the query")
    public FakerConfig setDefaultLimit(long value) {
        this.defaultLimit = value;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Config(value="faker.locale")
    @ConfigDescription(value="Default locale for generating character based data, specified as a IETF BCP 47 language tag string")
    public FakerConfig setLocale(String value) {
        this.locale = new Locale.Builder().setLanguageTag(value).build();
        return this;
    }

    public boolean isSequenceDetectionEnabled() {
        return this.sequenceDetectionEnabled;
    }

    @Config(value="faker.sequence-detection-enabled")
    @ConfigDescription(value="If true, when creating a table using existing data, columns with the number of distinct values close to\nthe number of rows are treated as sequences")
    public FakerConfig setSequenceDetectionEnabled(boolean value) {
        this.sequenceDetectionEnabled = value;
        return this;
    }

    public boolean isDictionaryDetectionEnabled() {
        return this.dictionaryDetectionEnabled;
    }

    @Config(value="faker.dictionary-detection-enabled")
    @ConfigDescription(value="If true, when creating a table using existing data, columns with a low number of distinct values\nare treated as dictionaries, and get the allowed_values column property populated with random values")
    public FakerConfig setDictionaryDetectionEnabled(boolean value) {
        this.dictionaryDetectionEnabled = value;
        return this;
    }
}

