/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.faker.FakerFunctionProvider;
import io.trino.plugin.faker.FakerMetadata;
import io.trino.plugin.faker.FakerPageSinkProvider;
import io.trino.plugin.faker.FakerPageSourceProvider;
import io.trino.plugin.faker.FakerSplitManager;
import io.trino.plugin.faker.FakerTransactionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FakerConnector
implements Connector {
    private final FakerMetadata metadata;
    private final FakerSplitManager splitManager;
    private final FakerPageSourceProvider pageSourceProvider;
    private final FakerPageSinkProvider pageSinkProvider;
    private final FakerFunctionProvider functionProvider;

    @Inject
    public FakerConnector(FakerMetadata metadata, FakerSplitManager splitManager, FakerPageSourceProvider pageSourceProvider, FakerPageSinkProvider pageSinkProvider, FakerFunctionProvider functionProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.functionProvider = Objects.requireNonNull(functionProvider, "functionPovider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return FakerTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Set.of(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT);
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return ImmutableList.of((Object)PropertyMetadata.doubleProperty((String)"null_probability", (String)"Default probability of null values in any column that allows them, in any table of this schema", null, nullProbability -> FakerConnector.checkProperty(0.0 <= nullProbability && nullProbability <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "null_probability value must be between 0 and 1, inclusive"), (boolean)false), (Object)PropertyMetadata.longProperty((String)"default_limit", (String)"Default limit of rows returned from any table in this schema, if not specified in the query", null, defaultLimit -> FakerConnector.checkProperty(1L <= defaultLimit, (ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "default_limit value must be equal or greater than 1"), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"sequence_detection_enabled", (String)"If true, when creating a table using existing data, columns with the number of distinct values close to\nthe number of rows are treated as sequences", null, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"dictionary_detection_enabled", (String)"If true, when creating a table using existing data, columns with a low number of distinct values\nare treated as dictionaries, and get the allowed_values column property populated with random values", null, (boolean)false));
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return ImmutableList.of((Object)PropertyMetadata.doubleProperty((String)"null_probability", (String)"Default probability of null values in any column in this table that allows them", null, nullProbability -> FakerConnector.checkProperty(0.0 <= nullProbability && nullProbability <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "null_probability value must be between 0 and 1, inclusive"), (boolean)false), (Object)PropertyMetadata.longProperty((String)"default_limit", (String)"Default limit of rows returned from this table if not specified in the query", null, defaultLimit -> FakerConnector.checkProperty(1L <= defaultLimit, (ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "default_limit value must be equal or greater than 1"), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"sequence_detection_enabled", (String)"If true, when creating a table using existing data, columns with the number of distinct values close to\nthe number of rows are treated as sequences", null, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"dictionary_detection_enabled", (String)"If true, when creating a table using existing data, columns with a low number of distinct values\nare treated as dictionaries, and get the allowed_values column property populated with random values", null, (boolean)false));
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return ImmutableList.of((Object)PropertyMetadata.doubleProperty((String)"null_probability", (String)"Default probability of null values in this column, if it allows them", null, nullProbability -> FakerConnector.checkProperty(0.0 <= nullProbability && nullProbability <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "null_probability value must be between 0 and 1, inclusive"), (boolean)false), (Object)PropertyMetadata.stringProperty((String)"generator", (String)"Name of the Faker library generator used to generate data for this column", null, generator -> {
            try {
                this.pageSourceProvider.validateGenerator((String)generator);
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "generator must be a valid Faker expression", (Throwable)e);
            }
        }, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"min", (String)"Minimum generated value (inclusive)", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"max", (String)"Maximum generated value (inclusive)", null, (boolean)false), (Object)new PropertyMetadata("allowed_values", "List of allowed values", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, null, false, value -> (List)((List)value).stream().map(String.class::cast).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.stringProperty((String)"step", (String)"If set, generate sequential values with this step. For date and time columns set this to a duration", null, (boolean)false));
    }

    private static void checkProperty(boolean expression, ErrorCodeSupplier errorCode, String errorMessage) {
        if (!expression) {
            throw new TrinoException(errorCode, errorMessage);
        }
    }

    public Optional<FunctionProvider> getFunctionProvider() {
        return Optional.of(this.functionProvider);
    }
}

