/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.faker.FakerConfig;
import io.trino.plugin.faker.FakerConnector;
import io.trino.plugin.faker.FakerFunctionProvider;
import io.trino.plugin.faker.FakerMetadata;
import io.trino.plugin.faker.FakerPageSinkProvider;
import io.trino.plugin.faker.FakerPageSourceProvider;
import io.trino.plugin.faker.FakerSplitManager;
import io.trino.spi.NodeManager;
import io.trino.spi.type.TypeManager;
import jakarta.inject.Inject;
import java.util.Objects;

public class FakerModule
implements Module {
    private final NodeManager nodeManager;
    private final TypeManager typeManager;

    @Inject
    public FakerModule(NodeManager nodeManager, TypeManager typeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(FakerConnector.class).in(Scopes.SINGLETON);
        binder.bind(FakerMetadata.class).in(Scopes.SINGLETON);
        binder.bind(FakerSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(FakerPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(FakerPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(FakerFunctionProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FakerConfig.class);
    }
}

