/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.plugin.faker.Literal;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PropertyValues {
    private PropertyValues() {
    }

    public static Object propertyValue(ColumnMetadata column, String property) {
        Type type;
        Object propertyValue = column.getProperties().get(property);
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof Collection) {
            Collection propertyValues = (Collection)propertyValue;
            return propertyValues.stream().map(String.class::cast).map(value -> {
                try {
                    return Literal.parse(value, column.getType());
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property must only contain valid %s literals, failed to parse `%s`".formatted(property, column.getType().getDisplayName(), value), (Throwable)e);
                }
            }).collect(ImmutableList.toImmutableList());
        }
        if (property.equals("step") && (DateType.DATE.equals((Object)(type = column.getType())) || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type instanceof TimeType || type instanceof TimeWithTimeZoneType)) {
            try {
                return Duration.valueOf((String)((String)propertyValue)).roundTo(TimeUnit.NANOSECONDS);
            }
            catch (IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property for a %s column must be a valid duration literal".formatted(property, type.getDisplayName()), (Throwable)e);
            }
        }
        try {
            return Literal.parse((String)propertyValue, column.getType());
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property must be a valid %s literal".formatted(property, column.getType().getDisplayName()), (Throwable)e);
        }
    }

    private static List<String> strings(Collection<?> values) {
        return (List)values.stream().map(String.class::cast).collect(ImmutableList.toImmutableList());
    }
}

