/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.connector.system.SystemColumnHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SystemSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SystemSplit.class);
    private final List<HostAddress> addresses;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<String> catalogName;

    public SystemSplit(HostAddress address, TupleDomain<ColumnHandle> constraint, Optional<String> catalogName) {
        this((List<HostAddress>)ImmutableList.of((Object)Objects.requireNonNull(address, "address is null")), constraint, catalogName);
    }

    @JsonCreator
    public SystemSplit(@JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="catalogName") Optional<String> catalogName) {
        Objects.requireNonNull(addresses, "addresses is null");
        Preconditions.checkArgument((!addresses.isEmpty() ? 1 : 0) != 0, (Object)"addresses is empty");
        this.addresses = ImmutableList.copyOf(addresses);
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<String> getCatalogName() {
        return this.catalogName;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + this.constraint.getRetainedSizeInBytes(columnHandle -> ((SystemColumnHandle)columnHandle).getRetainedSizeInBytes()) + SizeOf.sizeOf(this.catalogName, SizeOf::estimatedSizeOf);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", (Object)this.addresses.stream().map(HostAddress::toString).collect(Collectors.joining(","))).toString();
    }
}

