/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.SystemSessionProperties;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.matching.Pattern;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Optional;

public class FilterStatsRule
extends SimpleStatsRule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();
    private final FilterStatsCalculator filterStatsCalculator;

    public FilterStatsRule(StatsNormalizer normalizer, FilterStatsCalculator filterStatsCalculator) {
        super(normalizer);
        this.filterStatsCalculator = filterStatsCalculator;
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> doCalculate(FilterNode node, StatsCalculator.Context context) {
        PlanNodeStatsEstimate sourceStats = context.statsProvider().getStats(node.getSource());
        PlanNodeStatsEstimate estimate = this.filterStatsCalculator.filterStats(sourceStats, node.getPredicate(), context.session());
        if (SystemSessionProperties.isDefaultFilterFactorEnabled(context.session()) && estimate.isOutputRowCountUnknown()) {
            estimate = sourceStats.mapOutputRowCount(sourceRowCount -> sourceStats.getOutputRowCount() * 0.9);
        }
        return Optional.of(estimate);
    }
}

