/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.function.Supplier;

public class HeapSizeParser {
    private static final String RELATIVE_SUFFIX = "%";
    private static final Supplier<Long> AVAILABLE_HEAP_MEMORY = Suppliers.memoize(Runtime.getRuntime()::maxMemory);
    public static final HeapSizeParser DEFAULT = new HeapSizeParser(AVAILABLE_HEAP_MEMORY);
    private final Supplier<Long> maxHeapMemory;

    @VisibleForTesting
    HeapSizeParser(Supplier<Long> maxHeapMemory) {
        this.maxHeapMemory = Objects.requireNonNull(maxHeapMemory, "maxHeapMemory is null");
    }

    public DataSize parse(String value) {
        long maxHeapMemory = this.maxHeapMemory.get();
        Preconditions.checkState((maxHeapMemory > 0L ? 1 : 0) != 0, (Object)"maxHeapMemory must be positive");
        if (value.endsWith(RELATIVE_SUFFIX)) {
            double multiplier = Double.parseDouble(value.substring(0, value.length() - RELATIVE_SUFFIX.length()).trim()) / 100.0;
            return HeapSizeParser.checkHeapSizeMemory(DataSize.ofBytes((long)Math.round((double)maxHeapMemory * multiplier)).succinct(), maxHeapMemory);
        }
        return HeapSizeParser.checkHeapSizeMemory(DataSize.valueOf((String)value), maxHeapMemory);
    }

    private static DataSize checkHeapSizeMemory(DataSize heapSize, long maxHeapMemory) {
        Preconditions.checkArgument((heapSize.toBytes() <= maxHeapMemory ? 1 : 0) != 0, (Object)"Heap size cannot be greater than maximum heap size");
        Preconditions.checkArgument((heapSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"Heap size cannot be less than or equal to 0");
        return heapSize;
    }
}

