/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetAuthorizationStatement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SetAuthorizationTask
implements DataDefinitionTask<SetAuthorizationStatement> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public SetAuthorizationTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET AUTHORIZATION";
    }

    @Override
    public ListenableFuture<Void> execute(SetAuthorizationStatement statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        this.setEntityAuthorization(session, statement);
        return Futures.immediateVoidFuture();
    }

    private void setEntityAuthorization(Session session, SetAuthorizationStatement statement) {
        List<String> name = MetadataUtil.fillInNameParts(session, (Node)statement, statement.getOwnedEntityKind(), statement.getSource().getParts());
        switch (statement.getOwnedEntityKind()) {
            case "SCHEMA": {
                CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()));
                if (this.metadata.schemaExists(session, source)) break;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", source);
            }
            case "TABLE": {
                QualifiedObjectName tableName = new QualifiedObjectName(name.get(0), name.get(1), name.get(2));
                MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, name.get(0));
                RedirectionAwareTableHandle redirection = this.metadata.getRedirectionAwareTableHandle(session, tableName);
                if (redirection.tableHandle().isEmpty()) {
                    throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName);
                }
                if (!redirection.redirectedTableName().isPresent()) break;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Table %s is redirected to %s and SET TABLE AUTHORIZATION is not supported with table redirections", tableName, redirection.redirectedTableName().get());
            }
            case "VIEW": {
                QualifiedObjectName viewName = new QualifiedObjectName(name.get(0), name.get(1), name.get(2));
                MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, viewName.catalogName());
                if (this.metadata.isView(session, viewName)) break;
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", viewName);
            }
        }
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        Optional<String> maybeCatalogName = name.size() > 1 ? Optional.of(name.get(0)) : Optional.empty();
        MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, principal, maybeCatalogName.filter(catalog -> this.metadata.isCatalogManagedSecurity(session, (String)catalog)));
        EntityKindAndName entityKindAndName = new EntityKindAndName(statement.getOwnedEntityKind(), name);
        this.accessControl.checkCanSetEntityAuthorization(session.toSecurityContext(), entityKindAndName, principal);
        this.metadata.setEntityAuthorization(session, entityKindAndName, principal);
    }
}

