/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.ClientBuffer;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferMemoryManager;
import io.trino.execution.buffer.OutputBufferStateMachine;
import io.trino.execution.buffer.OutputBufferStatus;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.buffer.SerializedPageReference;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.plugin.base.metrics.TDigestHistogram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class BroadcastOutputBuffer
implements OutputBuffer {
    private final String taskInstanceId;
    private final OutputBufferStateMachine stateMachine;
    private final OutputBufferMemoryManager memoryManager;
    private final SerializedPageReference.PagesReleasedListener onPagesReleased;
    @GuardedBy(value="this")
    private volatile PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial(PipelinedOutputBuffers.BufferType.BROADCAST);
    @GuardedBy(value="this")
    private final Map<PipelinedOutputBuffers.OutputBufferId, ClientBuffer> buffers = new ConcurrentHashMap<PipelinedOutputBuffers.OutputBufferId, ClientBuffer>();
    @GuardedBy(value="this")
    private final List<SerializedPageReference> initialPagesForNewBuffers = new ArrayList<SerializedPageReference>();
    private final AtomicLong totalPagesAdded = new AtomicLong();
    private final AtomicLong totalRowsAdded = new AtomicLong();
    private final AtomicLong totalBufferedPages = new AtomicLong();
    private final AtomicBoolean hasBlockedBefore = new AtomicBoolean();
    private final Runnable notifyStatusChanged;

    public BroadcastOutputBuffer(String taskInstanceId, OutputBufferStateMachine stateMachine, DataSize maxBufferSize, Supplier<LocalMemoryContext> memoryContextSupplier, Executor notificationExecutor, Runnable notifyStatusChanged) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.memoryManager = new OutputBufferMemoryManager(maxBufferSize.toBytes(), Objects.requireNonNull(memoryContextSupplier, "memoryContextSupplier is null"), Objects.requireNonNull(notificationExecutor, "notificationExecutor is null"));
        this.onPagesReleased = (releasedPageCount, releasedMemorySizeInBytes) -> {
            Preconditions.checkState((this.totalBufferedPages.addAndGet(-releasedPageCount) >= 0L ? 1 : 0) != 0);
            this.memoryManager.updateMemoryUsage(-releasedMemorySizeInBytes);
        };
        this.notifyStatusChanged = Objects.requireNonNull(notifyStatusChanged, "notifyStatusChanged is null");
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public double getUtilization() {
        return this.memoryManager.getUtilization();
    }

    @Override
    public OutputBufferStatus getStatus() {
        return OutputBufferStatus.builder(this.outputBuffers.getVersion()).setOverutilized(this.getUtilization() > 0.5 && this.stateMachine.getState().canAddPages()).build();
    }

    @Override
    public OutputBufferInfo getInfo() {
        BufferState state = this.stateMachine.getState();
        Collection<ClientBuffer> buffers = this.buffers.values();
        return new OutputBufferInfo("BROADCAST", state, state.canAddBuffers(), state.canAddPages(), this.memoryManager.getBufferedBytes(), this.totalBufferedPages.get(), this.totalRowsAdded.get(), this.totalPagesAdded.get(), Optional.of((List)buffers.stream().map(ClientBuffer::getInfo).collect(ImmutableList.toImmutableList())), Optional.of(new TDigestHistogram(this.memoryManager.getUtilizationHistogram())), Optional.empty(), Optional.empty());
    }

    @Override
    public BufferState getState() {
        return this.stateMachine.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot set output buffers while holding a lock on this");
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        Preconditions.checkArgument((boolean)(newOutputBuffers instanceof PipelinedOutputBuffers), (Object)"newOutputBuffers is expected to be an instance of PipelinedOutputBuffers");
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            BufferState state = this.stateMachine.getState();
            if (state.isTerminal() || this.outputBuffers.getVersion() >= newOutputBuffers.getVersion()) {
                return;
            }
            this.outputBuffers.checkValidTransition(newOutputBuffers);
            this.outputBuffers = (PipelinedOutputBuffers)newOutputBuffers;
            for (Map.Entry<PipelinedOutputBuffers.OutputBufferId, Integer> entry : this.outputBuffers.getBuffers().entrySet()) {
                if (this.buffers.containsKey(entry.getKey())) continue;
                ClientBuffer buffer = this.getBuffer(entry.getKey());
                if (state.canAddPages()) continue;
                buffer.setNoMorePages();
            }
            if (this.outputBuffers.isNoMoreBufferIds()) {
                this.stateMachine.noMoreBuffers();
            }
        }
        if (!this.stateMachine.getState().canAddBuffers()) {
            this.noMoreBuffers();
        }
        this.checkFlushComplete();
    }

    @Override
    public ListenableFuture<Void> isFull() {
        return this.memoryManager.getBufferBlockedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(List<Slice> pages) {
        Collection<ClientBuffer> buffers;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot enqueue pages while holding a lock on this");
        Objects.requireNonNull(pages, "pages is null");
        if (!this.stateMachine.getState().canAddPages()) {
            return;
        }
        ImmutableList.Builder references = ImmutableList.builderWithExpectedSize((int)pages.size());
        long bytesAdded = 0L;
        long rowCount = 0L;
        for (Slice page : pages) {
            bytesAdded += page.getRetainedSize();
            int positionCount = PagesSerdeUtil.getSerializedPagePositionCount(page);
            rowCount += (long)positionCount;
            references.add((Object)new SerializedPageReference(page, positionCount, 1));
        }
        ImmutableList serializedPageReferences = references.build();
        this.totalRowsAdded.addAndGet(rowCount);
        this.totalPagesAdded.addAndGet(serializedPageReferences.size());
        this.totalBufferedPages.addAndGet(serializedPageReferences.size());
        this.memoryManager.updateMemoryUsage(bytesAdded);
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            if (this.stateMachine.getState().canAddBuffers()) {
                serializedPageReferences.forEach(SerializedPageReference::addReference);
                this.initialPagesForNewBuffers.addAll((Collection<SerializedPageReference>)serializedPageReferences);
            }
            buffers = this.safeGetBuffersSnapshot();
        }
        buffers.forEach(arg_0 -> BroadcastOutputBuffer.lambda$enqueue$0((List)serializedPageReferences, arg_0));
        SerializedPageReference.dereferencePages((List<SerializedPageReference>)serializedPageReferences, this.onPagesReleased);
        if (!this.hasBlockedBefore.get() && this.stateMachine.getState().canAddBuffers() && !this.isFull().isDone() && this.hasBlockedBefore.compareAndSet(false, true)) {
            this.notifyStatusChanged.run();
        }
    }

    @Override
    public void enqueue(int partitionNumber, List<Slice> pages) {
        Preconditions.checkState((partitionNumber == 0 ? 1 : 0) != 0, (Object)"Expected partition number to be zero");
        this.enqueue(pages);
    }

    @Override
    public ListenableFuture<BufferResult> get(PipelinedOutputBuffers.OutputBufferId outputBufferId, long startingSequenceId, DataSize maxSize) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot get pages while holding a lock on this");
        Objects.requireNonNull(outputBufferId, "outputBufferId is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        return this.getBuffer(outputBufferId).getPages(startingSequenceId, maxSize);
    }

    @Override
    public void acknowledge(PipelinedOutputBuffers.OutputBufferId bufferId, long sequenceId) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot acknowledge pages while holding a lock on this");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.getBuffer(bufferId).acknowledgePages(sequenceId);
    }

    @Override
    public void destroy(PipelinedOutputBuffers.OutputBufferId bufferId) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot destroy while holding a lock on this");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.getBuffer(bufferId).destroy();
        this.checkFlushComplete();
    }

    @Override
    public void setNoMorePages() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot set no more pages while holding a lock on this");
        this.stateMachine.noMorePages();
        this.memoryManager.setNoBlockOnFull();
        this.safeGetBuffersSnapshot().forEach(ClientBuffer::setNoMorePages);
        this.checkFlushComplete();
    }

    @Override
    public void destroy() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot destroy while holding a lock on this");
        if (this.stateMachine.finish()) {
            this.noMoreBuffers();
            this.safeGetBuffersSnapshot().forEach(ClientBuffer::destroy);
            this.memoryManager.setNoBlockOnFull();
            this.forceFreeMemory();
        }
    }

    @Override
    public void abort() {
        if (this.stateMachine.abort()) {
            this.memoryManager.setNoBlockOnFull();
            this.forceFreeMemory();
        }
    }

    @Override
    public long getPeakMemoryUsage() {
        return this.memoryManager.getPeakMemoryUsage();
    }

    @Override
    public Optional<Throwable> getFailureCause() {
        return this.stateMachine.getFailureCause();
    }

    @VisibleForTesting
    void forceFreeMemory() {
        this.memoryManager.close();
    }

    private synchronized ClientBuffer getBuffer(PipelinedOutputBuffers.OutputBufferId id) {
        ClientBuffer buffer = this.buffers.get(id);
        if (buffer != null) {
            return buffer;
        }
        BufferState state = this.stateMachine.getState();
        Preconditions.checkState((state == BufferState.ABORTED || state.canAddBuffers() || !this.outputBuffers.isNoMoreBufferIds() ? 1 : 0) != 0, (Object)"No more buffers already set");
        buffer = new ClientBuffer(this.taskInstanceId, id, this.onPagesReleased);
        if (state != BufferState.ABORTED) {
            Verify.verify((state != BufferState.FAILED ? 1 : 0) != 0, (String)"broadcast output buffer is not expected to fail internally", (Object[])new Object[0]);
            buffer.enqueuePages(this.initialPagesForNewBuffers);
            if (!state.canAddPages()) {
                buffer.setNoMorePages();
            }
            if (state == BufferState.FINISHED) {
                buffer.destroy();
            }
        }
        this.buffers.put(id, buffer);
        return buffer;
    }

    private synchronized Collection<ClientBuffer> safeGetBuffersSnapshot() {
        return ImmutableList.copyOf(this.buffers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreBuffers() {
        ImmutableList pages;
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Cannot set no more buffers while holding a lock on this");
        BroadcastOutputBuffer broadcastOutputBuffer = this;
        synchronized (broadcastOutputBuffer) {
            pages = ImmutableList.copyOf(this.initialPagesForNewBuffers);
            this.initialPagesForNewBuffers.clear();
            if (this.outputBuffers.isNoMoreBufferIds()) {
                Sets.SetView undeclaredCreatedBuffers = Sets.difference(this.buffers.keySet(), this.outputBuffers.getBuffers().keySet());
                Preconditions.checkState((boolean)undeclaredCreatedBuffers.isEmpty(), (String)"Final output buffers does not contain all created buffer ids: %s", (Object)undeclaredCreatedBuffers);
            }
        }
        SerializedPageReference.dereferencePages((List<SerializedPageReference>)pages, this.onPagesReleased);
    }

    private void checkFlushComplete() {
        BufferState state = this.stateMachine.getState();
        if (state != BufferState.FLUSHING && state != BufferState.NO_MORE_BUFFERS) {
            return;
        }
        if (this.safeGetBuffersSnapshot().stream().allMatch(ClientBuffer::isDestroyed)) {
            this.destroy();
        }
    }

    @VisibleForTesting
    OutputBufferMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    private static /* synthetic */ void lambda$enqueue$0(List serializedPageReferences, ClientBuffer partition) {
        partition.enqueuePages(serializedPageReferences);
    }
}

