/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.ImmutableIntArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.annotation.NotThreadSafe;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.metadata.Split;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@NotThreadSafe
interface SplitAssigner {
    public static final int SINGLE_SOURCE_PARTITION_ID = 0;

    public AssignmentResult assign(PlanNodeId var1, ListMultimap<Integer, Split> var2, boolean var3);

    public AssignmentResult finish();

    public record AssignmentResult(List<Partition> partitionsAdded, boolean noMorePartitions, List<PartitionUpdate> partitionUpdates, ImmutableIntArray sealedPartitions) {
        public AssignmentResult {
            partitionsAdded = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionsAdded, "partitionsAdded is null"));
            partitionUpdates = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionUpdates, "partitionUpdates is null"));
        }

        boolean isEmpty() {
            return this.partitionsAdded.isEmpty() && !this.noMorePartitions && this.partitionUpdates.isEmpty() && this.sealedPartitions.isEmpty();
        }

        public String debugInfo() {
            return MoreObjects.toStringHelper((Object)this).add("partitionsAdded", this.partitionsAdded).add("noMorePartitions", this.noMorePartitions).add("partitionUpdates", this.partitionUpdates.stream().map(PartitionUpdate::debugInfo).collect(Collectors.toList())).add("sealedPartitions", (Object)this.sealedPartitions).toString();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final ImmutableList.Builder<Partition> partitionsAdded = ImmutableList.builder();
            private boolean noMorePartitions;
            private final ImmutableList.Builder<PartitionUpdate> partitionUpdates = ImmutableList.builder();
            private final ImmutableIntArray.Builder sealedPartitions = ImmutableIntArray.builder();

            @CanIgnoreReturnValue
            public Builder addPartition(Partition partition) {
                this.partitionsAdded.add((Object)partition);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setNoMorePartitions() {
                this.noMorePartitions = true;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder updatePartition(PartitionUpdate partitionUpdate) {
                this.partitionUpdates.add((Object)partitionUpdate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder sealPartition(int partitionId) {
                this.sealedPartitions.add(partitionId);
                return this;
            }

            public AssignmentResult build() {
                return new AssignmentResult((List<Partition>)this.partitionsAdded.build(), this.noMorePartitions, (List<PartitionUpdate>)this.partitionUpdates.build(), this.sealedPartitions.build());
            }
        }
    }

    public record PartitionUpdate(int partitionId, PlanNodeId planNodeId, boolean readyForScheduling, ListMultimap<Integer, Split> splits, boolean noMoreSplits) {
        public PartitionUpdate {
            Objects.requireNonNull(planNodeId, "planNodeId is null");
            Preconditions.checkArgument((!readyForScheduling || !splits.isEmpty() ? 1 : 0) != 0, (Object)"partition update with empty splits marked as ready for scheduling");
            splits = ImmutableListMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(splits, "splits is null")));
        }

        public String debugInfo() {
            return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("planNodeId", (Object)this.planNodeId).add("readyForScheduling", this.readyForScheduling).add("splits", this.splits.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).size()))).add("noMoreSplits", this.noMoreSplits).toString();
        }
    }

    public record Partition(int partitionId, NodeRequirements nodeRequirements) {
        public Partition {
            Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
        }
    }
}

