/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.operator.HashGenerator;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class InterpretedHashGenerator
implements HashGenerator {
    private final List<Type> hashChannelTypes;
    @Nullable
    private final int[] hashChannels;
    private final MethodHandle[] hashCodeOperators;

    public static InterpretedHashGenerator createPagePrefixHashGenerator(List<Type> hashChannelTypes, TypeOperators typeOperators) {
        return new InterpretedHashGenerator(hashChannelTypes, null, typeOperators);
    }

    public static InterpretedHashGenerator createChannelsHashGenerator(List<Type> hashChannelTypes, int[] hashChannels, TypeOperators typeOperators) {
        return new InterpretedHashGenerator(hashChannelTypes, hashChannels, typeOperators);
    }

    private InterpretedHashGenerator(List<Type> hashChannelTypes, @Nullable int[] hashChannels, TypeOperators blockTypeOperators) {
        this.hashChannelTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannelTypes, "hashChannelTypes is null"));
        this.hashCodeOperators = new MethodHandle[hashChannelTypes.size()];
        for (int i = 0; i < this.hashCodeOperators.length; ++i) {
            this.hashCodeOperators[i] = blockTypeOperators.getHashCodeOperator(hashChannelTypes.get(i), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        }
        if (hashChannels == null) {
            this.hashChannels = null;
        } else {
            Preconditions.checkArgument((hashChannels.length == this.hashCodeOperators.length ? 1 : 0) != 0);
            this.hashChannels = InterpretedHashGenerator.isPositionalChannels(hashChannels) ? null : hashChannels;
        }
    }

    @Override
    public long hashPosition(int position, Page page) {
        long result = 0L;
        for (int i = 0; i < this.hashCodeOperators.length; ++i) {
            Block block = page.getBlock(this.hashChannels == null ? i : this.hashChannels[i]);
            result = CombineHashFunction.getHash(result, this.nullSafeHash(i, block, position));
        }
        return result;
    }

    private long nullSafeHash(int operatorIndex, Block block, int position) {
        try {
            return block.isNull(position) ? 0L : this.hashCodeOperators[operatorIndex].invokeExact(block, position);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashChannelTypes", this.hashChannelTypes).add("hashChannels", (Object)(this.hashChannels == null ? "<identity>" : Arrays.toString(this.hashChannels))).toString();
    }

    private static boolean isPositionalChannels(int[] hashChannels) {
        for (int i = 0; i < hashChannels.length; ++i) {
            if (hashChannels[i] == i) continue;
            return false;
        }
        return true;
    }
}

