/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.trino.operator.PageWithPositionEqualsAndHash;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePageWithPositionEqualsAndHash
implements PageWithPositionEqualsAndHash {
    private final int[] equalityChannels;
    private final BlockTypeOperators.BlockPositionIsIdentical[] identicalOperators;
    private final BlockTypeOperators.BlockPositionHashCode[] hashOperators;

    public SimplePageWithPositionEqualsAndHash(List<Type> channelTypes, List<Integer> equalityChannels, BlockTypeOperators blockTypeOperators) {
        Objects.requireNonNull(channelTypes, "channelTypes is null");
        Preconditions.checkArgument((channelTypes.size() == equalityChannels.size() ? 1 : 0) != 0, (Object)"channelTypes and equalityChannels must have the same size");
        this.equalityChannels = Ints.toArray((Collection)Objects.requireNonNull(equalityChannels, "equalityChannels is null"));
        this.identicalOperators = new BlockTypeOperators.BlockPositionIsIdentical[this.equalityChannels.length];
        this.hashOperators = new BlockTypeOperators.BlockPositionHashCode[this.equalityChannels.length];
        for (int index = 0; index < this.identicalOperators.length; ++index) {
            Type type = channelTypes.get(index);
            this.identicalOperators[index] = blockTypeOperators.getIdenticalOperator(type);
            this.hashOperators[index] = blockTypeOperators.getHashCodeOperator(type);
        }
    }

    @Override
    public boolean equals(Page left, int leftPosition, Page right, int rightPosition) {
        for (int i = 0; i < this.equalityChannels.length; ++i) {
            Block rightBlock;
            int equalityChannel = this.equalityChannels[i];
            Block leftBlock = left.getBlock(equalityChannel);
            if (this.identicalOperators[i].isIdentical(leftBlock, leftPosition, rightBlock = right.getBlock(equalityChannel), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hashCode(Page page, int position) {
        long hashCode = 0L;
        for (int i = 0; i < this.equalityChannels.length; ++i) {
            int equalityChannel = this.equalityChannels[i];
            Block block = page.getBlock(equalityChannel);
            hashCode = 31L * hashCode + this.hashOperators[i].hashCodeNullSafe(block, position);
        }
        return hashCode;
    }
}

