/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.operator.OperatorContext;
import io.trino.spi.Page;
import java.util.List;
import java.util.Objects;

public final class NestedLoopJoinPages {
    private final List<Page> pages;
    private final DataSize estimatedSize;

    NestedLoopJoinPages(List<Page> pages, DataSize estimatedSize, OperatorContext operatorContext) {
        Objects.requireNonNull(pages, "pages is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(estimatedSize, "estimatedSize is null");
        this.pages = ImmutableList.copyOf(pages);
        this.estimatedSize = estimatedSize;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public DataSize getEstimatedSize() {
        return this.estimatedSize;
    }
}

