/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.plugin.base.metrics.DurationTiming;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.spi.metrics.Metrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class PageProcessorMetrics {
    private static final String FILTER_TIME = "Filter CPU time";
    private static final String PROJECTION_TIME = "Projection CPU time";
    public static final String DYNAMIC_FILTER_TIME = "Dynamic Filter CPU time";
    public static final String DYNAMIC_FILTER_OUTPUT_POSITIONS = "Dynamic Filter output positions";
    private long filterTimeNanos;
    private boolean hasFilter;
    private long projectionTimeNanos;
    private boolean hasProjection;
    private long dynamicFilterTimeNanos;
    private long dynamicFilterOutputPositions;
    private boolean hasDynamicFilter;

    public void recordFilterTime(long filterTimeNanos) {
        this.filterTimeNanos += filterTimeNanos;
        this.hasFilter = true;
    }

    public void recordDynamicFilterMetrics(long filterTimeNanos, long outputPositions) {
        this.dynamicFilterTimeNanos += filterTimeNanos;
        this.dynamicFilterOutputPositions += outputPositions;
        this.hasDynamicFilter = true;
    }

    public void recordProjectionTime(long projectionTimeNanos) {
        this.projectionTimeNanos += projectionTimeNanos;
        this.hasProjection = true;
    }

    public Metrics getMetrics() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)((this.hasFilter ? 1 : 0) + (this.hasDynamicFilter ? 2 : 0) + (this.hasProjection ? 1 : 0)));
        if (this.hasFilter) {
            builder.put((Object)FILTER_TIME, (Object)new DurationTiming(new Duration((double)this.filterTimeNanos, TimeUnit.NANOSECONDS)));
        }
        if (this.hasDynamicFilter) {
            builder.put((Object)DYNAMIC_FILTER_TIME, (Object)new DurationTiming(new Duration((double)this.dynamicFilterTimeNanos, TimeUnit.NANOSECONDS)));
            builder.put((Object)DYNAMIC_FILTER_OUTPUT_POSITIONS, (Object)new LongCount(this.dynamicFilterOutputPositions));
        }
        if (this.hasProjection) {
            builder.put((Object)PROJECTION_TIME, (Object)new DurationTiming(new Duration((double)this.projectionTimeNanos, TimeUnit.NANOSECONDS)));
        }
        return new Metrics((Map)builder.buildOrThrow());
    }
}

