/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import io.trino.operator.DriverYieldSignal;
import io.trino.operator.Work;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class ArgumentComputation {
    private final PageProjection projection;
    private final Type outputType;
    private final List<Integer> inputChannels;
    private final ConnectorSession session;

    private ArgumentComputation(PageProjection projection, Type outputType, List<Integer> inputChannels, ConnectorSession session) {
        this.projection = Objects.requireNonNull(projection, "projection is null");
        this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public Type getOutputType() {
        return this.outputType;
    }

    public List<Integer> getInputChannels() {
        return this.inputChannels;
    }

    public Block compute(Block[] blocks) {
        SourcePage page = SourcePage.create((Page)new Page(1, blocks));
        Work<Block> work = this.projection.project(this.session, new DriverYieldSignal(), this.projection.getInputChannels().getInputChannels(page), SelectedPositions.positionsRange(0, 1));
        boolean done = false;
        while (!done) {
            done = work.process();
        }
        return work.getResult();
    }

    public static class ArgumentComputationSupplier {
        private final Supplier<PageProjection> projection;
        private final Type outputType;
        private final List<Integer> inputChannels;
        private final ConnectorSession session;

        public ArgumentComputationSupplier(Supplier<PageProjection> projection, Type outputType, List<Integer> inputChannels, ConnectorSession session) {
            this.projection = Objects.requireNonNull(projection, "projection is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null");
            this.inputChannels = Objects.requireNonNull(inputChannels, "inputChannels is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public ArgumentComputation get() {
            return new ArgumentComputation(this.projection.get(), this.outputType, this.inputChannels, this.session);
        }
    }
}

