/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import io.trino.client.QueryData;
import io.trino.server.protocol.JsonEncodingUtils;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonBytesQueryData
implements QueryData {
    private final ConnectorSession connectorSession;
    private final JsonEncodingUtils.TypeEncoder[] typeEncoders;
    private final int[] sourcePageChannels;
    private final List<Page> pages;
    private final Consumer<TrinoException> exceptionHandler;

    public JsonBytesQueryData(ConnectorSession connectorSession, Consumer<TrinoException> exceptionHandler, JsonEncodingUtils.TypeEncoder[] typeEncoders, int[] sourcePageChannels, List<Page> pages) {
        this.connectorSession = Objects.requireNonNull(connectorSession, "connectorSession");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler is null");
        this.typeEncoders = Objects.requireNonNull(typeEncoders, "typeEncoders is null");
        this.sourcePageChannels = Objects.requireNonNull(sourcePageChannels, "sourcePageChannels is null");
        this.pages = ImmutableList.copyOf(pages);
    }

    public void writeTo(JsonGenerator generator) {
        JsonEncodingUtils.writePagesToJsonGenerator(this.connectorSession, this.exceptionHandler, generator, this.typeEncoders, this.sourcePageChannels, this.pages);
    }

    public boolean isNull() {
        return false;
    }

    public long getRowsCount() {
        return this.pages.stream().mapToLong(Page::getPositionCount).sum();
    }
}

