/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.trino.client.QueryData;
import io.trino.client.QueryDataJacksonModule;
import io.trino.client.spooling.Segment;
import io.trino.server.protocol.JsonBytesQueryData;
import java.io.IOException;

public class ServerQueryDataJacksonModule
extends SimpleModule {
    public ServerQueryDataJacksonModule() {
        super(ServerQueryDataJacksonModule.class.getSimpleName(), Version.unknownVersion());
        this.addDeserializer(QueryData.class, (JsonDeserializer)new QueryDataJacksonModule.Deserializer());
        this.addSerializer(QueryData.class, (JsonSerializer)new ServerQueryDataSerializer());
        this.addSerializer(Segment.class, (JsonSerializer)new QueryDataJacksonModule.SegmentSerializer());
    }

    public static class ServerQueryDataSerializer
    extends QueryDataJacksonModule.QueryDataSerializer {
        public void serialize(QueryData value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value instanceof JsonBytesQueryData) {
                JsonBytesQueryData jsonBytesQueryData = (JsonBytesQueryData)value;
                jsonBytesQueryData.writeTo(generator);
            } else {
                super.serialize(value, generator, provider);
            }
        }
    }
}

