/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class PasswordAuthenticatorConfig {
    private Optional<String> userMappingPattern = Optional.empty();
    private Optional<File> userMappingFile = Optional.empty();
    private List<File> passwordAuthenticatorFiles = ImmutableList.of((Object)new File("etc/password-authenticator.properties"));

    public Optional<String> getUserMappingPattern() {
        return this.userMappingPattern;
    }

    @Config(value="http-server.authentication.password.user-mapping.pattern")
    public PasswordAuthenticatorConfig setUserMappingPattern(String userMappingPattern) {
        this.userMappingPattern = Optional.ofNullable(userMappingPattern);
        return this;
    }

    public Optional<@FileExists File> getUserMappingFile() {
        return this.userMappingFile;
    }

    @Config(value="http-server.authentication.password.user-mapping.file")
    public PasswordAuthenticatorConfig setUserMappingFile(File userMappingFile) {
        this.userMappingFile = Optional.ofNullable(userMappingFile);
        return this;
    }

    @NotNull
    @NotEmpty(message="At least one password authenticator config file is required")
    public @NotNull @NotEmpty(message="At least one password authenticator config file is required") List<@FileExists File> getPasswordAuthenticatorFiles() {
        return this.passwordAuthenticatorFiles;
    }

    @Config(value="password-authenticator.config-files")
    @ConfigDescription(value="Ordered list of password authenticator config files")
    public PasswordAuthenticatorConfig setPasswordAuthenticatorFiles(List<String> passwordAuthenticatorFiles) {
        this.passwordAuthenticatorFiles = (List)passwordAuthenticatorFiles.stream().map(File::new).collect(ImmutableList.toImmutableList());
        return this;
    }
}

