/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.inject.Inject;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.ui.AuthInfo;
import io.trino.server.ui.FixedUserWebUiConfig;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;
import java.util.Optional;

@Path(value="/ui/preview/auth/info")
@ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
public class FixedUserPreviewResource {
    private final String username;

    @Inject
    public FixedUserPreviewResource(FixedUserWebUiConfig config) {
        this.username = Objects.requireNonNull(config, "config is null").getUsername();
    }

    @GET
    @Produces(value={"application/json"})
    public AuthInfo getAuthInfo() {
        return new AuthInfo("fixed", false, true, Optional.of(this.username));
    }
}

