/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.RowExpressionCompiler;
import io.trino.sql.relational.RowExpression;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class BytecodeGeneratorContext {
    private final RowExpressionCompiler rowExpressionCompiler;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final FunctionManager functionManager;
    private final Variable wasNull;
    private final ClassDefinition classDefinition;
    private final List<Parameter> contextArguments;

    public BytecodeGeneratorContext(RowExpressionCompiler rowExpressionCompiler, Scope scope, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionManager functionManager, ClassDefinition classDefinition, List<Parameter> contextArguments) {
        Objects.requireNonNull(rowExpressionCompiler, "rowExpressionCompiler is null");
        Objects.requireNonNull(cachedInstanceBinder, "cachedInstanceBinder is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(functionManager, "functionManager is null");
        Objects.requireNonNull(classDefinition, "classDefinition is null");
        this.rowExpressionCompiler = rowExpressionCompiler;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.functionManager = functionManager;
        this.wasNull = scope.getVariable("wasNull");
        this.classDefinition = classDefinition;
        this.contextArguments = ImmutableList.copyOf(contextArguments);
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public BytecodeNode generate(RowExpression expression) {
        return this.rowExpressionCompiler.compile(expression, this.scope);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        return this.functionManager.getScalarFunctionImplementation(resolvedFunction, invocationConvention);
    }

    public BytecodeNode generateCall(ResolvedFunction resolvedFunction, List<BytecodeNode> arguments) {
        return BytecodeUtils.generateInvocation(this.scope, resolvedFunction, this.functionManager, arguments, this.callSiteBinder);
    }

    public BytecodeNode generateFullCall(ResolvedFunction resolvedFunction, List<RowExpression> arguments) {
        List argumentCompilers = (List)arguments.stream().map(this::argumentCompiler).collect(ImmutableList.toImmutableList());
        Function<MethodHandle, BytecodeNode> instance = instanceFactory -> this.scope.getThis().getField(this.cachedInstanceBinder.getCachedInstance((MethodHandle)instanceFactory));
        return BytecodeUtils.generateFullInvocation(this.scope, resolvedFunction, this.functionManager, instance, argumentCompilers, this.callSiteBinder);
    }

    private Function<Optional<Class<?>>, BytecodeNode> argumentCompiler(RowExpression argument) {
        return lambdaInterface -> this.rowExpressionCompiler.compile(argument, this.scope, (Optional<Class<?>>)lambdaInterface);
    }

    public Variable wasNull() {
        return this.wasNull;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    public RowExpressionCompiler getRowExpressionCompiler() {
        return this.rowExpressionCompiler;
    }

    public CachedInstanceBinder getCachedInstanceBinder() {
        return this.cachedInstanceBinder;
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public List<Parameter> getContextArguments() {
        return this.contextArguments;
    }
}

