/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.connector.DynamicFilter;
import io.trino.sql.gen.CursorProcessorCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.DynamicPageFilter;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.gen.columnar.PageFilterEvaluator;
import io.trino.sql.relational.RowExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExpressionCompiler {
    private final CursorProcessorCompiler cursorProcessorCompiler;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final ColumnarFilterCompiler columnarFilterCompiler;

    @Inject
    public ExpressionCompiler(CursorProcessorCompiler cursorProcessorCompiler, PageFunctionCompiler pageFunctionCompiler, ColumnarFilterCompiler columnarFilterCompiler) {
        this.cursorProcessorCompiler = Objects.requireNonNull(cursorProcessorCompiler, "cursorProcessorCompiler is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.columnarFilterCompiler = Objects.requireNonNull(columnarFilterCompiler, "columnarFilterCompiler is null");
    }

    public Supplier<CursorProcessor> compileCursorProcessor(Optional<RowExpression> filter, List<RowExpression> projections, Object uniqueKey) {
        return this.cursorProcessorCompiler.compileCursorProcessor(filter, projections, uniqueKey);
    }

    public Function<DynamicFilter, PageProcessor> compilePageProcessor(boolean columnarFilterEvaluationEnabled, Optional<RowExpression> filter, Optional<DynamicPageFilter> dynamicPageFilter, List<? extends RowExpression> projections, Optional<String> classNameSuffix, OptionalInt initialBatchSize) {
        Optional<Object> filterFunctionSupplier = Optional.empty();
        Optional<Supplier<FilterEvaluator>> columnarFilterEvaluatorSupplier = FilterEvaluator.createColumnarFilterEvaluator(columnarFilterEvaluationEnabled, filter, this.columnarFilterCompiler);
        if (columnarFilterEvaluatorSupplier.isEmpty()) {
            filterFunctionSupplier = filter.map(expression -> this.pageFunctionCompiler.compileFilter((RowExpression)expression, classNameSuffix));
        }
        List pageProjectionSuppliers = (List)projections.stream().map(projection -> this.pageFunctionCompiler.compileProjection((RowExpression)projection, classNameSuffix)).collect(ImmutableList.toImmutableList());
        Optional<Object> finalFilterFunctionSupplier = filterFunctionSupplier;
        return dynamicFilter -> {
            Optional<FilterEvaluator> filterEvaluator = columnarFilterEvaluatorSupplier.map(Supplier::get);
            if (filterEvaluator.isEmpty()) {
                filterEvaluator = finalFilterFunctionSupplier.map(Supplier::get).map(PageFilterEvaluator::new);
            }
            List pageProjections = (List)pageProjectionSuppliers.stream().map(Supplier::get).collect(ImmutableList.toImmutableList());
            Optional<FilterEvaluator> dynamicFilterEvaluator = dynamicPageFilter.map(pageFilter -> pageFilter.createDynamicPageFilterEvaluator(this.columnarFilterCompiler, (DynamicFilter)dynamicFilter)).map(Supplier::get);
            return new PageProcessor(filterEvaluator, dynamicFilterEvaluator, pageProjections, initialBatchSize);
        };
    }

    @VisibleForTesting
    public Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections) {
        return () -> this.compilePageProcessor(true, filter, Optional.empty(), projections, Optional.empty(), OptionalInt.empty()).apply(DynamicFilter.EMPTY);
    }

    @VisibleForTesting
    public Supplier<PageProcessor> compilePageProcessor(Optional<RowExpression> filter, List<? extends RowExpression> projections, int initialBatchSize) {
        return () -> this.compilePageProcessor(true, filter, Optional.empty(), projections, Optional.empty(), OptionalInt.of(initialBatchSize)).apply(DynamicFilter.EMPTY);
    }
}

