/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.units.DataSize;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.planner.DynamicFilterSourceConsumer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;

public class LocalDynamicFilterConsumer
implements DynamicFilterSourceConsumer {
    private final Map<DynamicFilterId, Integer> buildChannels;
    private final Map<DynamicFilterId, Type> filterBuildTypes;
    private final List<Consumer<Map<DynamicFilterId, Domain>>> collectors;
    private final long domainSizeLimitInBytes;
    @GuardedBy(value="this")
    private Integer expectedPartitionCount;
    @GuardedBy(value="this")
    private int collectedPartitionCount;
    @GuardedBy(value="this")
    private volatile boolean collected;
    private final Queue<TupleDomain<DynamicFilterId>> summaryDomains = new ConcurrentLinkedQueue<TupleDomain<DynamicFilterId>>();
    private final AtomicLong summaryDomainsRetainedSizeInBytes = new AtomicLong();

    public LocalDynamicFilterConsumer(Map<DynamicFilterId, Integer> buildChannels, Map<DynamicFilterId, Type> filterBuildTypes, List<Consumer<Map<DynamicFilterId, Domain>>> collectors, DataSize domainSizeLimit) {
        this.buildChannels = Objects.requireNonNull(buildChannels, "buildChannels is null");
        this.filterBuildTypes = Objects.requireNonNull(filterBuildTypes, "filterBuildTypes is null");
        Verify.verify((boolean)buildChannels.keySet().equals(filterBuildTypes.keySet()), (String)"filterBuildTypes and buildChannels must have same keys", (Object[])new Object[0]);
        Objects.requireNonNull(collectors, "collectors is null");
        Preconditions.checkArgument((!collectors.isEmpty() ? 1 : 0) != 0, (Object)"collectors is empty");
        this.collectors = ImmutableList.copyOf(collectors);
        this.domainSizeLimitInBytes = domainSizeLimit.toBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartition(TupleDomain<DynamicFilterId> domain) {
        TupleDomain<DynamicFilterId> result;
        if (this.collected) {
            return;
        }
        long domainRetainedSizeInBytes = LocalDynamicFilterConsumer.getRetainedSizeInBytes(domain);
        this.summaryDomainsRetainedSizeInBytes.addAndGet(domainRetainedSizeInBytes);
        this.summaryDomains.add(domain);
        this.unionSummaryDomainsIfNecessary(false);
        LocalDynamicFilterConsumer localDynamicFilterConsumer = this;
        synchronized (localDynamicFilterConsumer) {
            boolean allPartitionsCollected;
            Verify.verify((this.expectedPartitionCount == null || this.collectedPartitionCount < this.expectedPartitionCount ? 1 : 0) != 0);
            if (this.collected) {
                this.clearSummaryDomains();
                return;
            }
            ++this.collectedPartitionCount;
            boolean bl = allPartitionsCollected = this.expectedPartitionCount != null && this.collectedPartitionCount == this.expectedPartitionCount;
            if (allPartitionsCollected) {
                this.unionSummaryDomainsIfNecessary(true);
            }
            boolean sizeLimitExceeded = false;
            TupleDomain<DynamicFilterId> summary = this.summaryDomains.poll();
            if (summary != null) {
                long summarySize = LocalDynamicFilterConsumer.getRetainedSizeInBytes(summary);
                if (summarySize > this.domainSizeLimitInBytes) {
                    this.summaryDomainsRetainedSizeInBytes.addAndGet(-summarySize);
                    sizeLimitExceeded = true;
                } else {
                    this.summaryDomains.add(summary);
                }
            }
            if (!(allPartitionsCollected || sizeLimitExceeded || domain.isAll())) {
                return;
            }
            if (sizeLimitExceeded || domain.isAll()) {
                this.clearSummaryDomains();
                result = TupleDomain.all();
            } else {
                Verify.verify((this.expectedPartitionCount != null && this.collectedPartitionCount == this.expectedPartitionCount ? 1 : 0) != 0);
                Verify.verify((this.summaryDomains.size() == 1 ? 1 : 0) != 0);
                result = this.summaryDomains.poll();
                Verify.verify((result != null ? 1 : 0) != 0);
                long currentSize = this.summaryDomainsRetainedSizeInBytes.addAndGet(-LocalDynamicFilterConsumer.getRetainedSizeInBytes(result));
                Verify.verify((currentSize == 0L ? 1 : 0) != 0, (String)"currentSize is expected to be zero: %s", (long)currentSize);
            }
            this.collected = true;
        }
        this.collectors.forEach(arg_0 -> this.lambda$addPartition$0((TupleDomain)result, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPartitionCount(int partitionCount) {
        TupleDomain<DynamicFilterId> result;
        LocalDynamicFilterConsumer localDynamicFilterConsumer = this;
        synchronized (localDynamicFilterConsumer) {
            if (this.collected) {
                return;
            }
            Preconditions.checkState((this.expectedPartitionCount == null ? 1 : 0) != 0, (Object)"setPartitionCount should be called only once");
            this.expectedPartitionCount = partitionCount;
            if (this.collectedPartitionCount < this.expectedPartitionCount) {
                return;
            }
            if (partitionCount == 0) {
                result = TupleDomain.none();
            } else {
                this.unionSummaryDomainsIfNecessary(true);
                Verify.verify((this.summaryDomains.size() == 1 ? 1 : 0) != 0);
                result = this.summaryDomains.poll();
                Verify.verify((result != null ? 1 : 0) != 0);
                long currentSize = this.summaryDomainsRetainedSizeInBytes.addAndGet(-LocalDynamicFilterConsumer.getRetainedSizeInBytes(result));
                Verify.verify((currentSize == 0L ? 1 : 0) != 0, (String)"currentSize is expected to be zero: %s", (long)currentSize);
            }
            this.collected = true;
        }
        this.collectors.forEach(arg_0 -> this.lambda$setPartitionCount$0((TupleDomain)result, arg_0));
    }

    private void unionSummaryDomainsIfNecessary(boolean force) {
        TupleDomain<DynamicFilterId> domain;
        if (this.summaryDomainsRetainedSizeInBytes.get() < this.domainSizeLimitInBytes && !force) {
            return;
        }
        ArrayList<TupleDomain<DynamicFilterId>> domains = new ArrayList<TupleDomain<DynamicFilterId>>();
        long domainsRetainedSizeInBytes = 0L;
        while ((domain = this.summaryDomains.poll()) != null) {
            domains.add(domain);
            domainsRetainedSizeInBytes += LocalDynamicFilterConsumer.getRetainedSizeInBytes(domain);
        }
        if (domains.isEmpty()) {
            return;
        }
        TupleDomain union = TupleDomain.columnWiseUnion(domains);
        long unionSize = LocalDynamicFilterConsumer.getRetainedSizeInBytes((TupleDomain<DynamicFilterId>)union);
        if (this.summaryDomainsRetainedSizeInBytes.get() - domainsRetainedSizeInBytes + unionSize > this.domainSizeLimitInBytes) {
            union = union.simplify(1);
            unionSize = LocalDynamicFilterConsumer.getRetainedSizeInBytes((TupleDomain<DynamicFilterId>)union);
        }
        this.summaryDomainsRetainedSizeInBytes.addAndGet(unionSize - domainsRetainedSizeInBytes);
        long currentSize = this.summaryDomainsRetainedSizeInBytes.get();
        Verify.verify((currentSize >= 0L ? 1 : 0) != 0, (String)"currentSize is expected to be greater than or equal to zero: %s", (long)currentSize);
        this.summaryDomains.add((TupleDomain<DynamicFilterId>)union);
    }

    @Override
    public synchronized boolean isDomainCollectionComplete() {
        return this.collected;
    }

    private void clearSummaryDomains() {
        TupleDomain<DynamicFilterId> domain;
        long domainsRetainedSizeInBytes = 0L;
        while ((domain = this.summaryDomains.poll()) != null) {
            domainsRetainedSizeInBytes += LocalDynamicFilterConsumer.getRetainedSizeInBytes(domain);
        }
        this.summaryDomainsRetainedSizeInBytes.addAndGet(-domainsRetainedSizeInBytes);
        long currentSize = this.summaryDomainsRetainedSizeInBytes.get();
        Verify.verify((currentSize >= 0L ? 1 : 0) != 0, (String)"currentSize is expected to be greater than or equal to zero: %s", (long)currentSize);
    }

    private Map<DynamicFilterId, Domain> convertTupleDomain(TupleDomain<DynamicFilterId> result) {
        if (result.isNone()) {
            return (Map)this.buildChannels.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), filterId -> Domain.none((Type)this.filterBuildTypes.get(filterId))));
        }
        HashMap domains = new HashMap((Map)result.getDomains().get());
        this.buildChannels.keySet().forEach(filterId -> domains.putIfAbsent(filterId, Domain.all((Type)this.filterBuildTypes.get(filterId))));
        return ImmutableMap.copyOf(domains);
    }

    public static LocalDynamicFilterConsumer create(JoinNode planNode, List<Type> buildSourceTypes, Set<DynamicFilterId> collectedFilters, List<Consumer<Map<DynamicFilterId, Domain>>> collectors, DataSize domainSizeLimit) {
        Preconditions.checkArgument((!planNode.getDynamicFilters().isEmpty() ? 1 : 0) != 0, (Object)"Join node dynamicFilters is empty.");
        Preconditions.checkArgument((!collectedFilters.isEmpty() ? 1 : 0) != 0, (Object)"Collected dynamic filters set is empty");
        Preconditions.checkArgument((boolean)planNode.getDynamicFilters().keySet().containsAll(collectedFilters), (Object)"Collected dynamic filters set is not subset of join dynamic filters");
        PlanNode buildNode = planNode.getRight();
        Map buildChannels = (Map)planNode.getDynamicFilters().entrySet().stream().filter(entry -> collectedFilters.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Symbol buildSymbol = (Symbol)entry.getValue();
            int buildChannelIndex = buildNode.getOutputSymbols().indexOf(buildSymbol);
            Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
            return buildChannelIndex;
        }));
        Map filterBuildTypes = (Map)buildChannels.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Type)buildSourceTypes.get((Integer)entry.getValue())));
        return new LocalDynamicFilterConsumer(buildChannels, filterBuildTypes, collectors, domainSizeLimit);
    }

    public Map<DynamicFilterId, Integer> getBuildChannels() {
        return this.buildChannels;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("buildChannels", this.buildChannels).add("filterBuildTypes", this.filterBuildTypes).add("domainSizeLimitInBytes", this.domainSizeLimitInBytes).add("expectedPartitionCount", (Object)this.expectedPartitionCount).add("collectedPartitionCount", this.collectedPartitionCount).add("collected", this.collected).add("summaryDomains", this.summaryDomains).add("summaryDomainsRetainedSizeInBytes", (Object)this.summaryDomainsRetainedSizeInBytes).toString();
    }

    private static long getRetainedSizeInBytes(TupleDomain<DynamicFilterId> summary) {
        return summary.getRetainedSizeInBytes(DynamicFilterId::getRetainedSizeInBytes);
    }

    private /* synthetic */ void lambda$setPartitionCount$0(TupleDomain result, Consumer collector) {
        collector.accept(this.convertTupleDomain((TupleDomain<DynamicFilterId>)result));
    }

    private /* synthetic */ void lambda$addPartition$0(TupleDomain result, Consumer collector) {
        collector.accept(this.convertTupleDomain((TupleDomain<DynamicFilterId>)result));
    }
}

