/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import io.trino.Session;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.PlanBuilder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.RelationPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.SubqueryExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final PlannerContext plannerContext;
    private final Session session;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, PlannerContext plannerContext, Optional<TranslationMap> outerContext, Session session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.plannerContext = plannerContext;
        this.session = session;
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<io.trino.sql.tree.Expression> expressions, Analysis.SubqueryAnalysis subqueries) {
        for (io.trino.sql.tree.Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, subqueries);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, io.trino.sql.tree.Expression expression, Analysis.SubqueryAnalysis subqueries) {
        Iterable allSubExpressions = Traverser.forTree(this.recurseExpression(builder)).depthFirstPreOrder((Object)expression);
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, allSubExpressions, subqueries.getInPredicatesSubqueries()))) {
            builder = this.planInPredicate(builder, cluster, subqueries);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, allSubExpressions, subqueries.getSubqueries()))) {
            builder = this.planScalarSubquery(builder, cluster);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, allSubExpressions, subqueries.getExistsSubqueries()))) {
            builder = this.planExists(builder, cluster);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, allSubExpressions, subqueries.getQuantifiedComparisonSubqueries()))) {
            builder = this.planQuantifiedComparison(builder, cluster, subqueries);
        }
        return builder;
    }

    private <T extends io.trino.sql.tree.Expression> List<T> selectSubqueries(PlanBuilder subPlan, Iterable<Node> allSubExpressions, List<T> candidates) {
        return (List)candidates.stream().filter(candidate -> Streams.stream((Iterable)allSubExpressions).anyMatch(child -> child == candidate)).filter(candidate -> !subPlan.canTranslate((io.trino.sql.tree.Expression)candidate)).collect(ImmutableList.toImmutableList());
    }

    private SuccessorsFunction<Node> recurseExpression(PlanBuilder subPlan) {
        return expression -> {
            io.trino.sql.tree.Expression value;
            if (!(expression instanceof io.trino.sql.tree.Expression) || !this.analysis.isColumnReference(value = (io.trino.sql.tree.Expression)expression) && !subPlan.canTranslate(value)) {
                return expression.getChildren();
            }
            return ImmutableList.of();
        };
    }

    private <T extends io.trino.sql.tree.Expression> Collection<Cluster<T>> cluster(Scope scope, List<T> expressions) {
        LinkedHashMap<ScopeAware, List> sets = new LinkedHashMap<ScopeAware, List>();
        for (io.trino.sql.tree.Expression expression : expressions) {
            sets.computeIfAbsent(ScopeAware.scopeAwareKey(expression, this.analysis, scope), key -> new ArrayList()).add(expression);
        }
        return (Collection)sets.values().stream().map(cluster -> Cluster.newCluster(cluster, scope, this.analysis)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Cluster<InPredicate> cluster, Analysis.SubqueryAnalysis subqueries) {
        InPredicate predicate = cluster.getRepresentative();
        io.trino.sql.tree.Expression value = predicate.getValue();
        SubqueryExpression subquery = (SubqueryExpression)predicate.getValueList();
        Symbol output = this.symbolAllocator.newSymbol("expr", (Type)BooleanType.BOOLEAN);
        subPlan = this.handleSubqueries(subPlan, value, subqueries);
        subPlan = this.planInPredicate(subPlan, value, subquery, output, (io.trino.sql.tree.Expression)predicate, this.analysis.getPredicateCoercions((io.trino.sql.tree.Expression)predicate));
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, io.trino.sql.tree.Expression value, SubqueryExpression subquery, Symbol output, io.trino.sql.tree.Expression originalExpression, Analysis.PredicateCoercions predicateCoercions) {
        QueryPlanner.PlanAndMappings subqueryPlan = this.planSubquery((io.trino.sql.tree.Expression)subquery, predicateCoercions.getSubqueryCoercion(), subPlan.getTranslations());
        QueryPlanner.PlanAndMappings valuePlan = this.planValue(subPlan, value, predicateCoercions.getValueType(), predicateCoercions.getValueCoercion());
        return new PlanBuilder(valuePlan.getSubPlan().getTranslations(), new ApplyNode(this.idAllocator.getNextId(), valuePlan.getSubPlan().getRoot(), subqueryPlan.getSubPlan().getRoot(), (Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)output, (Object)new ApplyNode.In(valuePlan.get(value), subqueryPlan.get((io.trino.sql.tree.Expression)subquery))), valuePlan.getSubPlan().getRoot().getOutputSymbols(), (Node)originalExpression));
    }

    private PlanBuilder planScalarSubquery(PlanBuilder subPlan, Cluster<SubqueryExpression> cluster) {
        Symbol column;
        SubqueryExpression scalarSubquery = cluster.getRepresentative();
        RelationPlan relationPlan = this.planSubquery((io.trino.sql.tree.Expression)scalarSubquery, subPlan.getTranslations());
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        PlanNode root = new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan.getRoot());
        Type type = this.analysis.getType((io.trino.sql.tree.Expression)scalarSubquery);
        RelationType descriptor = relationPlan.getDescriptor();
        List<Symbol> fieldMappings = relationPlan.getFieldMappings();
        if (descriptor.getVisibleFieldCount() > 1) {
            column = this.symbolAllocator.newSymbol("row", type);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < descriptor.getAllFieldCount(); ++i) {
                Field field = descriptor.getFieldByIndex(i);
                if (field.isHidden()) continue;
                fields.add((Object)fieldMappings.get(i).toSymbolReference());
            }
            Cast expression = new Cast(new Row((List<Expression>)fields.build()), type);
            root = new ProjectNode(this.idAllocator.getNextId(), root, Assignments.of(column, expression));
        } else {
            column = (Symbol)Iterables.getOnlyElement(fieldMappings);
        }
        return this.appendCorrelatedJoin(subPlan, root, scalarSubquery.getQuery(), JoinType.INNER, Booleans.TRUE, this.mapAll(cluster, subPlan.getScope(), column));
    }

    public PlanBuilder appendCorrelatedJoin(PlanBuilder subPlan, PlanNode subquery, Query query, JoinType type, Expression filterCondition, Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> mappings) {
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(mappings), new CorrelatedJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), subquery, subPlan.getRoot().getOutputSymbols(), type, filterCondition, (Node)query));
    }

    private PlanBuilder planExists(PlanBuilder subPlan, Cluster<ExistsPredicate> cluster) {
        ExistsPredicate existsPredicate = cluster.getRepresentative();
        io.trino.sql.tree.Expression subquery = existsPredicate.getSubquery();
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), exists)), new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), this.planSubquery(subquery, subPlan.getTranslations()).getRoot(), (Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)exists, (Object)new ApplyNode.Exists()), subPlan.getRoot().getOutputSymbols(), (Node)subquery));
    }

    private RelationPlan planSubquery(io.trino.sql.tree.Expression subquery, TranslationMap outerContext) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, Optional.of(outerContext), this.session, this.recursiveSubqueries).process((Node)subquery, null);
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, Cluster<QuantifiedComparisonExpression> cluster, Analysis.SubqueryAnalysis subqueries) {
        QuantifiedComparisonExpression quantifiedComparison = cluster.getRepresentative();
        ComparisonExpression.Operator operator = quantifiedComparison.getOperator();
        QuantifiedComparisonExpression.Quantifier quantifier = quantifiedComparison.getQuantifier();
        io.trino.sql.tree.Expression value = quantifiedComparison.getValue();
        SubqueryExpression subquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        subPlan = this.handleSubqueries(subPlan, value, subqueries);
        Symbol output = this.symbolAllocator.newSymbol("expr", (Type)BooleanType.BOOLEAN);
        Analysis.PredicateCoercions predicateCoercions = this.analysis.getPredicateCoercions((io.trino.sql.tree.Expression)quantifiedComparison);
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ComparisonExpression.Operator.EQUAL -> {
                switch (quantifier) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ALL: {
                        subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, (io.trino.sql.tree.Expression)subquery, output, predicateCoercions);
                        yield new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(quantifiedComparison, this.analysis, subPlan.getScope()), (Object)output)), subPlan.getRoot());
                    }
                    case ANY: 
                    case SOME: 
                }
                subPlan = this.planInPredicate(subPlan, value, subquery, output, (io.trino.sql.tree.Expression)quantifiedComparison, predicateCoercions);
                yield new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
            }
            case ComparisonExpression.Operator.NOT_EQUAL -> {
                switch (quantifier) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ALL: {
                        yield this.addNegation(this.planInPredicate(subPlan, value, subquery, output, (io.trino.sql.tree.Expression)quantifiedComparison, predicateCoercions), cluster, output);
                    }
                    case ANY: 
                    case SOME: 
                }
                yield this.addNegation(this.planQuantifiedComparison(subPlan, ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, value, (io.trino.sql.tree.Expression)subquery, output, predicateCoercions), cluster, output);
            }
            case ComparisonExpression.Operator.LESS_THAN, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, ComparisonExpression.Operator.GREATER_THAN, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> {
                subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, (io.trino.sql.tree.Expression)subquery, output, predicateCoercions);
                yield new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
            }
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", operator.getValue(), quantifier));
        };
    }

    private PlanBuilder addNegation(PlanBuilder subPlan, Cluster<? extends io.trino.sql.tree.Expression> cluster, Symbol input) {
        Symbol output = this.symbolAllocator.newSymbol("not", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(output, IrExpressions.not(this.plannerContext.getMetadata(), input.toSymbolReference())).build()));
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, ComparisonExpression.Operator operator, QuantifiedComparisonExpression.Quantifier quantifier, io.trino.sql.tree.Expression value, io.trino.sql.tree.Expression subquery, Symbol assignment, Analysis.PredicateCoercions predicateCoercions) {
        QueryPlanner.PlanAndMappings subqueryPlan = this.planSubquery(subquery, predicateCoercions.getSubqueryCoercion(), subPlan.getTranslations());
        QueryPlanner.PlanAndMappings valuePlan = this.planValue(subPlan, value, predicateCoercions.getValueType(), predicateCoercions.getValueCoercion());
        return new PlanBuilder(valuePlan.getSubPlan().getTranslations(), new ApplyNode(this.idAllocator.getNextId(), valuePlan.getSubPlan().getRoot(), subqueryPlan.getSubPlan().getRoot(), (Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)assignment, (Object)new ApplyNode.QuantifiedComparison(SubqueryPlanner.mapOperator(operator), SubqueryPlanner.mapQuantifier(quantifier), valuePlan.get(value), subqueryPlan.get(subquery))), valuePlan.getSubPlan().getRoot().getOutputSymbols(), (Node)subquery));
    }

    private static ApplyNode.Quantifier mapQuantifier(QuantifiedComparisonExpression.Quantifier quantifier) {
        return switch (quantifier) {
            default -> throw new MatchException(null, null);
            case QuantifiedComparisonExpression.Quantifier.ALL -> ApplyNode.Quantifier.ALL;
            case QuantifiedComparisonExpression.Quantifier.ANY -> ApplyNode.Quantifier.ANY;
            case QuantifiedComparisonExpression.Quantifier.SOME -> ApplyNode.Quantifier.SOME;
        };
    }

    private static ApplyNode.Operator mapOperator(ComparisonExpression.Operator operator) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ComparisonExpression.Operator.EQUAL -> ApplyNode.Operator.EQUAL;
            case ComparisonExpression.Operator.NOT_EQUAL -> ApplyNode.Operator.NOT_EQUAL;
            case ComparisonExpression.Operator.LESS_THAN -> ApplyNode.Operator.LESS_THAN;
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> ApplyNode.Operator.LESS_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.GREATER_THAN -> ApplyNode.Operator.GREATER_THAN;
            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> ApplyNode.Operator.GREATER_THAN_OR_EQUAL;
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> throw new IllegalArgumentException();
        };
    }

    private QueryPlanner.PlanAndMappings planValue(PlanBuilder subPlan, io.trino.sql.tree.Expression value, Type actualType, Optional<Type> coercion) {
        subPlan = subPlan.appendProjections((Iterable<io.trino.sql.tree.Expression>)ImmutableList.of((Object)value), this.symbolAllocator, this.idAllocator);
        Symbol column = subPlan.translate(value);
        Type declaredType = this.analysis.getType(value);
        if (!actualType.equals((Object)declaredType)) {
            Symbol wrapped = this.symbolAllocator.newSymbol("row", actualType);
            Assignments assignments = Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(wrapped, new Row((List<Expression>)ImmutableList.of((Object)column.toSymbolReference()))).build();
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments));
            column = wrapped;
        }
        return this.coerceIfNecessary(subPlan, column, value, coercion);
    }

    private QueryPlanner.PlanAndMappings planSubquery(io.trino.sql.tree.Expression subquery, Optional<Type> coercion, TranslationMap outerContext) {
        Type type = this.analysis.getType(subquery);
        Symbol column = this.symbolAllocator.newSymbol("row", type);
        RelationPlan relationPlan = this.planSubquery(subquery, outerContext);
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, (Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(subquery, this.analysis, relationPlan.getScope()), (Object)column), this.session, this.plannerContext);
        RelationType descriptor = relationPlan.getDescriptor();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (int i = 0; i < descriptor.getAllFieldCount(); ++i) {
            Field field = descriptor.getFieldByIndex(i);
            if (field.isHidden()) continue;
            fields.add((Object)relationPlan.getFieldMappings().get(i).toSymbolReference());
        }
        subqueryPlan = subqueryPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), relationPlan.getRoot(), Assignments.of(column, new Cast(new Row((List<Expression>)fields.build()), type))));
        return this.coerceIfNecessary(subqueryPlan, column, subquery, coercion);
    }

    private QueryPlanner.PlanAndMappings coerceIfNecessary(PlanBuilder subPlan, Symbol symbol, io.trino.sql.tree.Expression value, Optional<? extends Type> coercion) {
        Symbol coerced = symbol;
        if (coercion.isPresent()) {
            coerced = this.symbolAllocator.newSymbol("expr", coercion.get());
            Assignments assignments = Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(coerced, new Cast(symbol.toSymbolReference(), coercion.get())).build();
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments));
        }
        return new QueryPlanner.PlanAndMappings(subPlan, (Map<NodeRef<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of((Object)NodeRef.of((Node)value), (Object)coerced));
    }

    private <T extends io.trino.sql.tree.Expression> Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol> mapAll(Cluster<T> cluster, Scope scope, Symbol output) {
        return (Map)cluster.getExpressions().stream().collect(ImmutableMap.toImmutableMap(expression -> ScopeAware.scopeAwareKey(expression, this.analysis, scope), expression -> output, (first, second) -> first));
    }

    private static class Cluster<T extends io.trino.sql.tree.Expression> {
        private final List<T> expressions;

        private Cluster(List<T> expressions) {
            Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0, (Object)"Cluster is empty");
            this.expressions = ImmutableList.copyOf(expressions);
        }

        public static <T extends io.trino.sql.tree.Expression> Cluster<T> newCluster(List<T> expressions, Scope scope, Analysis analysis) {
            long count = expressions.stream().map(expression -> ScopeAware.scopeAwareKey(expression, analysis, scope)).distinct().count();
            Preconditions.checkArgument((count == 1L ? 1 : 0) != 0, (Object)"Cluster contains expressions that are not equivalent to each other");
            return new Cluster<T>(expressions);
        }

        public List<T> getExpressions() {
            return this.expressions;
        }

        public T getRepresentative() {
            return (T)((io.trino.sql.tree.Expression)this.expressions.get(0));
        }
    }
}

