/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.JsonPath;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class JsonPathType
extends AbstractVariableWidthType {
    public static final JsonPathType JSON_PATH = new JsonPathType();
    public static final String NAME = "JsonPath";

    private JsonPathType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), JsonPath.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        return this.getObject(block, position);
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        String pattern = valueBlock.getSlice(valuePosition).toStringUtf8();
        return new JsonPath(pattern);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Slice pattern = Slices.utf8Slice((String)((JsonPath)value).pattern());
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(pattern);
    }
}

