/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.MoreObjects;
import io.trino.likematcher.LikeMatcher;
import java.util.Objects;
import java.util.Optional;

public class LikePattern {
    private final String pattern;
    private final Optional<Character> escape;
    private final LikeMatcher matcher;

    public static LikePattern compile(String pattern, Optional<Character> escape) {
        return new LikePattern(pattern, escape, LikeMatcher.compile(pattern, escape));
    }

    public static LikePattern compile(String pattern, Optional<Character> escape, boolean optimize) {
        return new LikePattern(pattern, escape, LikeMatcher.compile(pattern, escape, optimize));
    }

    private LikePattern(String pattern, Optional<Character> escape, LikeMatcher matcher) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
        this.matcher = Objects.requireNonNull(matcher, "likeMatcher is null");
    }

    public String getPattern() {
        return this.pattern;
    }

    public Optional<Character> getEscape() {
        return this.escape;
    }

    public LikeMatcher getMatcher() {
        return this.matcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikePattern that = (LikePattern)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.escape, that.escape);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.escape);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).add("escape", this.escape).toString();
    }
}

