/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.trino.client.JsonQueryData;
import io.trino.client.QueryData;
import io.trino.client.TypedQueryData;
import io.trino.client.spooling.EncodedQueryData;
import io.trino.client.spooling.Segment;
import java.io.IOException;

public class QueryDataJacksonModule
extends SimpleModule {
    private static final TypeReference<EncodedQueryData> ENCODED_FORMAT = new TypeReference<EncodedQueryData>(){};

    public QueryDataJacksonModule() {
        super(QueryDataJacksonModule.class.getSimpleName(), Version.unknownVersion());
        this.addDeserializer(QueryData.class, (JsonDeserializer)new Deserializer());
        this.addSerializer(QueryData.class, (JsonSerializer)new QueryDataSerializer());
        this.addSerializer(Segment.class, (JsonSerializer)new SegmentSerializer());
    }

    private static <T> JsonSerializer<T> createSerializer(SerializerProvider provider, JavaType javaType) throws JsonMappingException {
        return BeanSerializerFactory.instance.createSerializer(provider, javaType);
    }

    public static class Deserializer
    extends StdDeserializer<QueryData> {
        public Deserializer() {
            super(QueryData.class);
        }

        public QueryData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                return new JsonQueryData((JsonNode)jsonParser.readValueAsTree());
            }
            return (QueryData)jsonParser.readValueAs(ENCODED_FORMAT);
        }
    }

    public static class QueryDataSerializer
    extends StdSerializer<QueryData> {
        public QueryDataSerializer() {
            super(QueryData.class);
        }

        public void serialize(QueryData value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            if (value == null) {
                provider.defaultSerializeNull(generator);
            } else if (value instanceof JsonQueryData) {
                generator.writeTree((TreeNode)((JsonQueryData)value).getNode());
            } else if (value instanceof TypedQueryData) {
                provider.defaultSerializeValue(((TypedQueryData)value).getIterable(), generator);
            } else if (value instanceof EncodedQueryData) {
                QueryDataJacksonModule.createSerializer(provider, provider.constructType(EncodedQueryData.class)).serialize((Object)value, generator, provider);
            } else {
                throw new IllegalArgumentException("Unsupported QueryData implementation: " + value.getClass().getSimpleName());
            }
        }

        public boolean isEmpty(SerializerProvider provider, QueryData value) {
            return value == null || value.isNull();
        }
    }

    public static class SegmentSerializer
    extends StdSerializer<Segment> {
        public SegmentSerializer() {
            super(Segment.class);
        }

        public void serialize(Segment value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            this.serializeWithType(value, gen, provider, SegmentSerializer.segmentSerializer(provider));
        }

        public void serializeWithType(Segment value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
            QueryDataJacksonModule.createSerializer(provider, provider.constructSpecializedType(provider.constructType(Segment.class), value.getClass())).serializeWithType((Object)value, gen, provider, typeSerializer);
        }

        private static TypeSerializer segmentSerializer(SerializerProvider provider) {
            try {
                return provider.findTypeSerializer(provider.constructType(Segment.class));
            }
            catch (JsonMappingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

