/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.auth.external;

import io.trino.client.auth.external.Token;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public class TokenPollResult {
    private final State state;
    private final Optional<String> errorMessage;
    private final Optional<URI> nextTokenUri;
    private final Optional<Token> token;

    public static TokenPollResult failed(String error) {
        return new TokenPollResult(State.FAILED, null, error, null);
    }

    public static TokenPollResult pending(URI uri) {
        return new TokenPollResult(State.PENDING, null, null, uri);
    }

    public static TokenPollResult successful(Token token) {
        return new TokenPollResult(State.SUCCESSFUL, token, null, null);
    }

    private TokenPollResult(State state, Token token, String error, URI nextTokenUri) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.token = Optional.ofNullable(token);
        this.errorMessage = Optional.ofNullable(error);
        this.nextTokenUri = Optional.ofNullable(nextTokenUri);
    }

    public boolean isFailed() {
        return this.state == State.FAILED;
    }

    public boolean isPending() {
        return this.state == State.PENDING;
    }

    public Token getToken() {
        return this.token.orElseThrow(() -> new IllegalStateException("state is " + String.valueOf((Object)this.state)));
    }

    public String getError() {
        return this.errorMessage.orElseThrow(() -> new IllegalStateException("state is " + String.valueOf((Object)this.state)));
    }

    public URI getNextTokenUri() {
        return this.nextTokenUri.orElseThrow(() -> new IllegalStateException("state is " + String.valueOf((Object)this.state)));
    }

    private static enum State {
        PENDING,
        SUCCESSFUL,
        FAILED;

    }
}

