/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client.spooling.encoding;

import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import io.trino.client.CloseableIterator;
import io.trino.client.QueryDataDecoder;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class CompressedQueryDataDecoder
implements QueryDataDecoder {
    protected final QueryDataDecoder delegate;

    public CompressedQueryDataDecoder(QueryDataDecoder delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    abstract void decompress(byte[] var1, byte[] var2) throws IOException;

    @Override
    public CloseableIterator<List<Object>> decode(InputStream stream, DataAttributes metadata) throws IOException {
        Optional<Integer> expectedDecompressedSize = metadata.getOptional(DataAttribute.UNCOMPRESSED_SIZE, Integer.class);
        int segmentSize = metadata.get(DataAttribute.SEGMENT_SIZE, Integer.class);
        if (expectedDecompressedSize.isPresent()) {
            int uncompressedSize = expectedDecompressedSize.get();
            try (InputStream inputStream = stream;){
                byte[] input = new byte[segmentSize];
                byte[] output = new byte[uncompressedSize];
                int readBytes = ByteStreams.read((InputStream)inputStream, (byte[])input, (int)0, (int)segmentSize);
                Verify.verify((readBytes == segmentSize ? 1 : 0) != 0, (String)"Expected to read %s bytes but got %s", (int)segmentSize, (int)readBytes);
                this.decompress(input, output);
                CloseableIterator<List<Object>> closeableIterator = this.delegate.decode(new ByteArrayInputStream(output), metadata);
                return closeableIterator;
            }
        }
        return this.delegate.decode(stream, metadata);
    }
}

