/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import net.datafaker.internal.helper.SingletonLocale;

class FakeValuesContext {
    private final SingletonLocale singletonLocale;
    private final String filename;
    private final int filenameHashCode;
    private final String path;
    private final URL url;
    private final int urlHashCode;

    private FakeValuesContext(Locale locale) {
        this(locale, FakeValuesContext.getFilename(locale), FakeValuesContext.getFilename(locale), null);
    }

    private FakeValuesContext(Locale locale, URL url) {
        this(locale, FakeValuesContext.getFilename(locale), null, url);
    }

    private FakeValuesContext(Locale locale, String filename, String path) {
        this(locale, filename, path, null);
    }

    private FakeValuesContext(Locale locale, String filename, String path, URL url) {
        this.singletonLocale = SingletonLocale.get(locale);
        this.filename = filename;
        this.path = path;
        this.url = url;
        this.filenameHashCode = filename == null ? 0 : filename.hashCode();
        try {
            this.urlHashCode = url == null ? 0 : url.toURI().hashCode();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid url: \"%s\"".formatted(url), e);
        }
    }

    public static FakeValuesContext of(Locale locale) {
        return new FakeValuesContext(locale);
    }

    public static FakeValuesContext of(Locale locale, URL url) {
        return new FakeValuesContext(locale, url);
    }

    public static FakeValuesContext of(Locale locale, String filename, String path) {
        return new FakeValuesContext(locale, filename, path);
    }

    public static FakeValuesContext of(Locale locale, String filename, String path, URL url) {
        return new FakeValuesContext(locale, filename, path, url);
    }

    private static String getFilename(Locale locale) {
        String lang = FakeValuesContext.language(locale);
        if ("".equals(locale.getCountry())) {
            return lang;
        }
        if ("".equals(locale.getLanguage())) {
            return "_" + locale.getCountry();
        }
        return lang + "-" + locale.getCountry();
    }

    private static String language(Locale locale) {
        return switch (locale.getLanguage()) {
            case "iw" -> "he";
            case "in" -> "id";
            case "ji" -> "yi";
            default -> locale.getLanguage();
        };
    }

    public Locale getLocale() {
        return this.singletonLocale.getLocale();
    }

    public String getFilename() {
        return this.filename;
    }

    String getPath() {
        return this.path;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeValuesContext that = (FakeValuesContext)o;
        if (!Objects.equals(this.singletonLocale, that.singletonLocale)) {
            return false;
        }
        if (!Objects.equals(this.filename, that.filename)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        int result = this.singletonLocale == null ? 0 : this.singletonLocale.hashCode();
        result = 31 * result + this.filenameHashCode;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.urlHashCode;
        return result;
    }

    public String toString() {
        return "FakeValuesContext{%s, filename='%s', path='%s', url=%s}".formatted(this.singletonLocale, this.filename, this.path, this.url);
    }
}

