/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.Transformer;

public class JavaObjectTransformer
implements Transformer<Object, Object> {
    private static final Map<Schema<Object, ?>, Consumer<Object>> SCHEMA2CONSUMER = new IdentityHashMap();
    private static final Map<Class<?>, Constructor<?>> CLASS2CONSTRUCTOR = new IdentityHashMap();
    private Optional<Object> sourceClazz = Optional.empty();

    @Override
    public Object apply(Object input, Schema<Object, ?> schema) {
        Class<?> clazz;
        Object result = null;
        if (input instanceof Class) {
            clazz = (Class<?>)input;
        } else {
            clazz = input.getClass();
            result = input;
        }
        if (clazz.isRecord()) {
            Constructor<?> recordConstructor = CLASS2CONSTRUCTOR.get(clazz);
            if (recordConstructor == null) {
                Class[] componentTypes = (Class[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
                try {
                    recordConstructor = clazz.getDeclaredConstructor(componentTypes);
                    CLASS2CONSTRUCTOR.put(clazz, recordConstructor);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Failed to initialize class " + clazz.getName(), e);
                }
            }
            result = this.getObject(schema, result, recordConstructor);
        } else if (!this.hasParameterlessPublicConstructor(clazz)) {
            Constructor<?> primaryConstructor = CLASS2CONSTRUCTOR.get(clazz);
            if (primaryConstructor == null) {
                primaryConstructor = clazz.getDeclaredConstructors()[0];
                CLASS2CONSTRUCTOR.put(clazz, primaryConstructor);
            }
            result = this.getObject(schema, result, primaryConstructor);
        } else {
            Consumer<Object> consumer;
            if (result == null) {
                try {
                    Constructor<?> primaryConstructor = CLASS2CONSTRUCTOR.get(clazz);
                    if (primaryConstructor == null) {
                        primaryConstructor = clazz.getDeclaredConstructors()[0];
                        CLASS2CONSTRUCTOR.put(clazz, primaryConstructor);
                    }
                    result = primaryConstructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((consumer = SCHEMA2CONSUMER.get(schema)) == null) {
                Field[] fields = schema.getFields();
                Map name2ClassField = Stream.of(clazz.getDeclaredFields()).collect(Collectors.toMap(java.lang.reflect.Field::getName, Function.identity()));
                java.lang.reflect.Field[] rFields = new java.lang.reflect.Field[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    rFields[i] = (java.lang.reflect.Field)name2ClassField.get(fields[i].getName());
                    rFields[i].setAccessible(true);
                }
                consumer = classObject -> {
                    for (int i = 0; i < fields.length; ++i) {
                        try {
                            rFields[i].set(classObject, fields[i].transform(classObject));
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("Failed to transform field " + String.valueOf(fields[i]), e);
                        }
                    }
                };
                SCHEMA2CONSUMER.put(schema, consumer);
            }
            consumer.accept(result);
        }
        return result;
    }

    @Override
    public Collection<Object> generate(Iterable<Object> input, Schema<Object, ?> schema) {
        ArrayList<Object> collection;
        if (input instanceof FakeSequence) {
            FakeSequence fakeSequence = (FakeSequence)input;
            if (fakeSequence.isInfinite()) {
                throw new IllegalArgumentException("Should be finite size: " + String.valueOf(fakeSequence));
            }
            collection = new ArrayList((Collection)fakeSequence.get());
        } else {
            collection = new ArrayList<Object>();
            for (Object o : input) {
                collection.add(o);
            }
        }
        for (Object e : collection) {
            this.apply(e, schema);
        }
        return collection;
    }

    public JavaObjectTransformer from(Class input) {
        this.sourceClazz = Optional.of(input);
        return this;
    }

    @Override
    public Stream<Object> generateStream(Schema<Object, ?> schema, long limit) {
        if (this.sourceClazz.isEmpty()) {
            return Stream.empty();
        }
        return Stream.generate(() -> this.apply(this.sourceClazz.get(), schema)).limit(limit);
    }

    @Override
    public void writeToOutputStream(OutputStream outputStream, Schema<Object, ?> schema, long limit) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Collection<Object> generate(Schema<Object, ?> schema, int limit) {
        return this.generateStream(schema, (long)limit).collect(Collectors.toList());
    }

    @Override
    public String getStartStream(Schema<Object, ?> schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getEndStream() {
        throw new UnsupportedOperationException();
    }

    private Object getObject(Schema<Object, ?> schema, Object result, Constructor<?> recordConstructor) {
        Field<Object, ?>[] fields = schema.getFields();
        Object[] values = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = fields[i].transform(result);
        }
        try {
            return recordConstructor.newInstance(values);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate " + recordConstructor.getDeclaringClass().getName(), e);
        }
    }

    private boolean hasParameterlessPublicConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }
}

