/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.transformations.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.sequence.FakeStream;
import net.datafaker.transformations.CompositeField;
import net.datafaker.transformations.Field;
import net.datafaker.transformations.Schema;
import net.datafaker.transformations.SimpleField;
import net.datafaker.transformations.Transformer;
import net.datafaker.transformations.sql.Casing;
import net.datafaker.transformations.sql.SqlDialect;

public class SqlTransformer<IN>
implements Transformer<IN, CharSequence> {
    private static final char DEFAULT_QUOTE = '\'';
    private static final char DEFAULT_CATALOG_SEPARATOR = '.';
    private static final String DEFAULT_SQL_IDENTIFIER = "\"\"";
    private static final String EMPTY_RESULT = "";
    private final Casing casing;
    private final char quote;
    private final char openSqlIdentifier;
    private final char closeSqlIdentifier;
    private final String tableName;
    private final String schemaName;
    private final boolean withBatchMode;
    private final int batchSize;
    private final Case keywordCase;
    private final boolean forceSqlQuoteIdentifierUsage;
    private final SqlDialect dialect;

    public static <IN> SqlTransformerBuilder<IN> builder() {
        return new SqlTransformerBuilder();
    }

    private SqlTransformer(String schemaName, String tableName, char quote, SqlDialect dialect, String sqlIdentifier, Casing casing, boolean withBatchMode, int batchSize, Case keywordCase, boolean forceSqlQuoteIdentifierUsage) {
        this.schemaName = schemaName;
        this.quote = quote;
        this.dialect = dialect;
        this.openSqlIdentifier = sqlIdentifier.charAt(0);
        this.closeSqlIdentifier = sqlIdentifier.length() == 1 ? sqlIdentifier.charAt(0) : sqlIdentifier.charAt(1);
        this.tableName = tableName;
        this.casing = casing;
        this.withBatchMode = withBatchMode;
        this.batchSize = batchSize;
        this.keywordCase = keywordCase;
        this.forceSqlQuoteIdentifierUsage = forceSqlQuoteIdentifierUsage;
    }

    private boolean isSqlQuoteIdentifierRequiredFor(String name) {
        if (this.forceSqlQuoteIdentifierUsage) {
            return true;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (!(this.casing == Casing.TO_UPPER && Character.isLowerCase(name.charAt(i)) || this.casing == Casing.TO_LOWER && Character.isUpperCase(name.charAt(i)) || name.charAt(i) == this.openSqlIdentifier || name.charAt(i) == this.closeSqlIdentifier) && name.charAt(i) != '.') continue;
            return true;
        }
        return false;
    }

    @Override
    public CharSequence apply(IN input, Schema<IN, ?> schema) {
        return this.apply((Object)input, (Schema)schema, 0L);
    }

    @Override
    public CharSequence apply(IN input, Schema<IN, ?> schema, long rowId) {
        Field[] fields = schema.getFields();
        if (fields.length == 0) {
            return EMPTY_RESULT;
        }
        if (this.withBatchMode) {
            if (rowId == 0L || this.batchSize > 0 && rowId % (long)this.batchSize == 0L) {
                return SqlDialect.getFirstRow(this.dialect, () -> this.appendTableInfo(fields), () -> this.addValues(input, fields, true), this.keywordCase);
            }
            return String.join((CharSequence)LINE_SEPARATOR, ",", SqlDialect.getOtherRow(this.dialect, () -> this.appendTableInfo(fields), () -> this.addValues(input, fields, true), this.keywordCase));
        }
        return String.join((CharSequence)" ", SQLKeyWords.INSERT_INTO.getValue(this.keywordCase), this.appendTableInfo(fields), SQLKeyWords.VALUES.getValue(this.keywordCase), this.addValues(input, fields, true));
    }

    private String addValues(IN input, Field<?, ? extends CharSequence>[] fields, Boolean isRoot) {
        StringJoiner result = new StringJoiner(", ");
        for (int i = 0; i < fields.length; ++i) {
            String fieldPrefix;
            if (this.dialect != null && !(fieldPrefix = this.dialect.getFieldPrefix(fields[i].getName())).isEmpty() && !isRoot.booleanValue()) {
                result.add(this.quote + this.dialect.getFieldPrefix(fields[i].getName()) + this.quote);
            }
            if (fields[i] instanceof SimpleField) {
                Class<?> clazz;
                Object value = ((SimpleField)fields[i]).transform(input);
                Class<?> clazz2 = clazz = value == null ? null : value.getClass();
                if (value == null || value instanceof Number || value instanceof Boolean || clazz.isPrimitive()) {
                    result.add(String.valueOf(value));
                    continue;
                }
                if (clazz.isArray()) {
                    Class<?> componentType = clazz.getComponentType();
                    result.add(SQLKeyWords.ARRAY.getValue(this.keywordCase) + this.dialect.getArrayStart() + (componentType.isPrimitive() ? this.handlePrimitivesInArray(componentType, value) : this.handleObjectInArray(value)) + this.dialect.getArrayEnd());
                    continue;
                }
                if (value instanceof Map) {
                    result.add(SQLKeyWords.MAP.getValue(this.keywordCase) + "(" + this.handleObjectInMap(value) + ")");
                    continue;
                }
                if (value instanceof Collection) {
                    result.add(SQLKeyWords.MULTISET.getValue(this.keywordCase) + "[" + this.handleObjectInCollection(value) + "]");
                    continue;
                }
                result.add(this.handleObject(value));
                continue;
            }
            if (fields[i] instanceof CompositeField) {
                result.add(this.dialect.getCompositePrefix(this.keywordCase) + this.addValues(input, ((CompositeField)fields[i]).getFields(), false));
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(fields[i]) + " not supported");
        }
        String res = result.toString();
        return !res.isEmpty() ? "(" + res + ")" : res;
    }

    private String handleObjectInArray(Object value) {
        StringBuilder result = new StringBuilder();
        Object[] array = (Object[])value;
        for (int j = 0; j < array.length; ++j) {
            result.append(this.handleObject(array[j]));
            if (j >= array.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private String handleObjectInCollection(Object value) {
        StringBuilder result = new StringBuilder();
        Collection collection = (Collection)value;
        int i = 0;
        for (Object elem : collection) {
            result.append(this.handleObject(elem));
            if (i < collection.size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    private String handleObjectInMap(Object value) {
        StringBuilder result = new StringBuilder();
        Map map = (Map)value;
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            result.append(this.handleObject(entry.getKey()));
            result.append(", ");
            result.append(this.handleObject(entry.getValue()));
            if (i < map.size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    private String handleObject(Object value) {
        if (value == null) {
            return SQLKeyWords.NULL.getValue(this.keywordCase);
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            String array = componentType.isPrimitive() ? this.handlePrimitivesInArray(componentType, value) : this.handleObjectInArray(value);
            return SQLKeyWords.ARRAY.getValue(this.keywordCase) + "[" + array + "]";
        }
        if (value instanceof Map) {
            return SQLKeyWords.MAP.getValue(this.keywordCase) + "(" + this.handleObjectInMap(value) + ")";
        }
        if (value instanceof Collection) {
            return SQLKeyWords.MULTISET.getValue(this.keywordCase) + "[" + this.handleObjectInCollection(value) + "]";
        }
        String strValue = value.toString();
        int length = strValue.length();
        boolean quoteRequired = !(value instanceof Number) && !(value instanceof Boolean);
        String res = this.handledObjectToString(length, strValue);
        return quoteRequired ? this.quote + res + this.quote : res;
    }

    private String handledObjectToString(int length, String strValue) {
        StringBuilder builder = new StringBuilder(length);
        for (int k = 0; k < length; ++k) {
            if (strValue.charAt(k) == this.quote) {
                builder.append('\\').append(this.quote);
                continue;
            }
            builder.append(strValue.charAt(k));
        }
        return builder.toString();
    }

    private String handlePrimitivesInArray(Class<?> componentType, Object value) {
        StringJoiner joiner;
        block10: {
            Object[] array;
            block13: {
                block12: {
                    block11: {
                        block9: {
                            joiner = new StringJoiner(", ");
                            if (componentType == Byte.TYPE) {
                                for (byte by : array = (byte[])value) {
                                    joiner.add(String.valueOf(by));
                                }
                            }
                            if (componentType == Short.TYPE) {
                                for (byte by : array = (Object[])((short[])value)) {
                                    joiner.add(String.valueOf(by));
                                }
                            }
                            if (componentType != Boolean.TYPE) break block9;
                            for (boolean bl : array = (Object[])((boolean[])value)) {
                                joiner.add(String.valueOf(bl));
                            }
                            break block10;
                        }
                        if (componentType != Integer.TYPE) break block11;
                        for (byte by : array = (Object[])((int[])value)) {
                            joiner.add(String.valueOf(by));
                        }
                        break block10;
                    }
                    if (componentType != Long.TYPE) break block12;
                    for (byte by : array = (Object[])((long[])value)) {
                        joiner.add(String.valueOf((long)by));
                    }
                    break block10;
                }
                if (componentType != Float.TYPE) break block13;
                for (byte by : array = (Object[])((float[])value)) {
                    joiner.add(String.valueOf((float)by));
                }
                break block10;
            }
            if (componentType != Double.TYPE) break block10;
            for (byte by : array = (Object[])((double[])value)) {
                joiner.add(String.valueOf((double)by));
            }
        }
        return joiner.toString();
    }

    private String appendTableInfo(Field<?, ? extends CharSequence>[] fields) {
        StringBuilder result = new StringBuilder();
        this.appendNameToQuery(result, this.schemaName);
        if (this.schemaName != null && !this.schemaName.isEmpty()) {
            result.append('.');
        }
        this.appendNameToQuery(result, this.tableName);
        result.append(" (");
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            boolean sqlIdentifierRequired = this.isSqlQuoteIdentifierRequiredFor(fieldName);
            if (sqlIdentifierRequired) {
                result.append(this.openSqlIdentifier);
            }
            for (int j = 0; j < fieldName.length(); ++j) {
                if (this.openSqlIdentifier == fieldName.charAt(j) || this.closeSqlIdentifier == fieldName.charAt(j)) {
                    result.append(this.openSqlIdentifier);
                }
                result.append(fieldName.charAt(j));
            }
            if (sqlIdentifierRequired) {
                result.append(this.closeSqlIdentifier);
            }
            if (i >= fields.length - 1) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    private void appendNameToQuery(StringBuilder sb, String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        boolean sqlIdentifierRequired = this.isSqlQuoteIdentifierRequiredFor(name);
        if (sqlIdentifierRequired) {
            sb.append(this.openSqlIdentifier);
        }
        sb.append(name);
        if (sqlIdentifierRequired) {
            sb.append(this.closeSqlIdentifier);
        }
    }

    @Override
    public String generate(Iterable<IN> input, Schema<IN, ?> schema) {
        List<IN> inputs;
        FakeSequence fakeSequence;
        if (schema.getFields().length == 0) {
            return EMPTY_RESULT;
        }
        if (input instanceof FakeSequence && (fakeSequence = (FakeSequence)input).isInfinite()) {
            throw new IllegalArgumentException("The sequence should be finite of size: " + String.valueOf(input));
        }
        if (input instanceof FakeStream) {
            FakeStream fakeStream = (FakeStream)input;
            Object stream = fakeStream.get();
            inputs = stream.toList();
        } else if (input instanceof FakeSequence) {
            FakeSequence fakeSequence2 = (FakeSequence)input;
            inputs = (ArrayList)fakeSequence2.get();
        } else if (input instanceof List) {
            List list = (List)input;
            inputs = list;
        } else {
            inputs = new ArrayList();
            for (IN o : input) {
                inputs.add(o);
            }
        }
        int limit = inputs.size();
        if (this.withBatchMode) {
            return this.generateBatchModeStatements(schema, inputs, limit);
        }
        return this.generateSeparatedStatements(schema, inputs, limit);
    }

    @Override
    public String generate(Schema<IN, ?> schema, int limit) {
        if (schema.getFields().length == 0) {
            return EMPTY_RESULT;
        }
        if (this.withBatchMode) {
            return this.generateBatchModeStatements(schema, null, limit);
        }
        return this.generateSeparatedStatements(schema, null, limit);
    }

    @Override
    public String getStartStream(Schema<IN, ?> schema) {
        throw new UnsupportedOperationException("Not supported for SQL transformer. Use generate or generateStream instead to create SQL statements.");
    }

    @Override
    public String getEndStream() {
        throw new UnsupportedOperationException("Not supported for SQL transformer. Use generate or generateStream instead to create SQL statements.");
    }

    private String generateBatchModeStatements(Schema<IN, ?> schema, List<IN> inputs, int limit) {
        StringBuilder sb = new StringBuilder();
        limit = inputs != null ? Math.min(limit, inputs.size()) : limit;
        for (int i = 0; i < limit; ++i) {
            Object input = inputs != null ? inputs.get(i) : null;
            sb.append((CharSequence)this.apply((Object)input, (Schema)schema, (long)i));
            if ((i != limit - 1 || sb.isEmpty()) && (this.batchSize <= 0 || (i + 1) % this.batchSize != 0)) continue;
            sb.append(SqlDialect.getLastRowSuffix(this.dialect, this.keywordCase));
            sb.append(";");
            if (i >= limit - 1 || sb.isEmpty()) continue;
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public Stream<CharSequence> generateStream(Schema<IN, ?> schema, long limit) {
        if (schema.getFields().length == 0) {
            return Stream.empty();
        }
        if (this.withBatchMode) {
            return Stream.iterate(new Interval(0, this.batchSize), interval -> (long)interval.start() <= limit, i -> i.add(this.batchSize)).map(interval -> {
                StringBuilder sb = new StringBuilder();
                for (int i = interval.start(); i < interval.end() && (long)i < limit; ++i) {
                    sb.append((CharSequence)this.apply((Object)null, (Schema)schema, (long)i));
                }
                sb.append(SqlDialect.getLastRowSuffix(this.dialect, this.keywordCase));
                sb.append(";");
                return sb.toString();
            });
        }
        return Stream.generate(() -> String.valueOf(this.apply((Object)null, (Schema)schema)) + ";").limit(limit);
    }

    private String generateSeparatedStatements(Schema<IN, ?> schema, List<IN> inputs, int limit) {
        StringJoiner data = new StringJoiner(LINE_SEPARATOR);
        limit = inputs != null ? Math.min(limit, inputs.size()) : limit;
        for (int i = 0; i < limit; ++i) {
            Object input = inputs != null ? inputs.get(i) : null;
            data.add(String.valueOf(this.apply((Object)input, (Schema)schema)) + ";");
        }
        return data.toString();
    }

    public static class SqlTransformerBuilder<IN> {
        private char quote = (char)39;
        private String sqlQuoteIdentifier = "\"\"";
        private String tableName = "MyTable";
        private String schemaName = "";
        private Casing casing = Casing.TO_UPPER;
        private boolean withBatchMode = false;
        private int batchSize = -1;
        private Case keywordCase = Case.UPPERCASE;
        private boolean forceSqlQuoteIdentifierUsage = false;
        private SqlDialect dialect;

        public SqlTransformerBuilder<IN> dialect(SqlDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public SqlTransformerBuilder<IN> casing(Casing casing) {
            this.casing = casing;
            this.dialect = null;
            return this;
        }

        public SqlTransformerBuilder<IN> quote(char quote) {
            this.quote = quote;
            return this;
        }

        public SqlTransformerBuilder<IN> sqlQuoteIdentifier(String sqlQuoteIdentifier) {
            this.sqlQuoteIdentifier = sqlQuoteIdentifier;
            this.dialect = null;
            return this;
        }

        public SqlTransformerBuilder<IN> tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public SqlTransformerBuilder<IN> schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public SqlTransformerBuilder<IN> batch() {
            this.withBatchMode = true;
            return this;
        }

        public SqlTransformerBuilder<IN> batch(int batchSize) {
            this.batchSize = batchSize;
            this.withBatchMode = true;
            return this;
        }

        public SqlTransformerBuilder<IN> keywordCase(Case caze) {
            this.keywordCase = caze;
            return this;
        }

        public SqlTransformerBuilder<IN> forceUseSqlQuoteIdentifier() {
            this.forceSqlQuoteIdentifierUsage = true;
            return this;
        }

        public SqlTransformer<IN> build() {
            if (this.dialect == null) {
                return new SqlTransformer(this.schemaName, this.tableName, this.quote, null, this.sqlQuoteIdentifier, this.casing, this.withBatchMode, this.batchSize, this.keywordCase, this.forceSqlQuoteIdentifierUsage);
            }
            return new SqlTransformer(this.schemaName, this.tableName, this.quote, this.dialect, this.dialect.getSqlQuoteIdentifier(), this.dialect.getUnquotedCasing(), this.withBatchMode, this.batchSize, this.keywordCase, this.forceSqlQuoteIdentifierUsage);
        }
    }

    public static enum Case {
        CAPITAL,
        LOWERCASE,
        UPPERCASE;

    }

    static enum SQLKeyWords {
        ARRAY("ARRAY", "array", "Array"),
        MAP("MAP", "map", "Map"),
        NAMED_STRUCT("NAMED_STRUCT", "named_struct", "Named_Struct"),
        INSERT_ALL("INSERT ALL", "insert all", "Insert All"),
        INSERT_INTO("INSERT INTO", "insert into", "Insert Into"),
        INTO("INTO", "into", "Into"),
        MULTISET("MULTISET", "multiset", "Multiset"),
        NULL("NULL", "null", "Null"),
        ROW("ROW", "row", "Row"),
        SELECT_1_FROM_DUAL("SELECT 1 FROM dual", "select 1 from dual", "Select 1 From dual"),
        VALUES("VALUES", "values", "Values");

        private final String upperCaseValue;
        private final String lowerCaseValue;
        private final String capitalValue;

        private SQLKeyWords(String upperCaseValue, String lowerCaseValue, String capitalValue) {
            this.upperCaseValue = upperCaseValue;
            this.lowerCaseValue = lowerCaseValue;
            this.capitalValue = capitalValue;
        }

        public String getValue(Case caze) {
            return switch (caze) {
                default -> throw new IncompatibleClassChangeError();
                case Case.UPPERCASE -> this.upperCaseValue;
                case Case.LOWERCASE -> this.lowerCaseValue;
                case Case.CAPITAL -> this.capitalValue;
            };
        }
    }

    private record Interval(int start, int end) {
        private Interval add(int offset) {
            return new Interval(this.start + offset, this.end + offset);
        }
    }
}

