/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.base.Preconditions;
import io.trino.plugin.faker.PropertyValues;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.Objects;

public record FakerColumnHandle(int columnIndex, String name, Type type, double nullProbability, String generator, Domain domain, ValueSet step) implements ColumnHandle
{
    public FakerColumnHandle {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(domain, "domain is null");
        Objects.requireNonNull(step, "step is null");
        Preconditions.checkState((step.isNone() || step.isSingleValue() ? 1 : 0) != 0, (Object)"step must be a single value");
    }

    public static FakerColumnHandle of(int columnId, ColumnMetadata column, double defaultNullProbability) {
        Object allowedValues;
        String generator;
        double nullProbability = 0.0;
        if (column.isNullable()) {
            nullProbability = column.getProperties().getOrDefault("null_probability", defaultNullProbability);
        }
        if ((generator = (String)column.getProperties().get("generator")) != null && !FakerColumnHandle.isCharacterColumn(column)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property can only be set for CHAR, VARCHAR or VARBINARY columns".formatted("generator"));
        }
        Object min = PropertyValues.propertyValue(column, "min");
        Object max = PropertyValues.propertyValue(column, "max");
        Domain domain = Domain.all((Type)column.getType());
        if (min != null || max != null) {
            if (FakerColumnHandle.isCharacterColumn(column)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` and `%s` properties cannot be set for CHAR, VARCHAR or VARBINARY columns".formatted("min", "max"));
            }
            domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)FakerColumnHandle.range(column.getType(), min, max), (Range[])new Range[0]), (boolean)false);
        }
        if ((allowedValues = PropertyValues.propertyValue(column, "allowed_values")) != null) {
            if (min != null || max != null || generator != null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property cannot be set together with `%s`, `%s`, and `%s` properties".formatted("allowed_values", "min", "max", "generator"));
            }
            domain = Domain.create((ValueSet)ValueSet.copyOf((Type)column.getType(), (Collection)((Collection)allowedValues)), (boolean)false);
        }
        return new FakerColumnHandle(columnId, column.getName(), column.getType(), nullProbability, generator, domain, FakerColumnHandle.stepValue(column));
    }

    private static boolean isCharacterColumn(ColumnMetadata column) {
        return column.getType() instanceof CharType || column.getType() instanceof VarcharType || column.getType() instanceof VarbinaryType;
    }

    private static ValueSet stepValue(ColumnMetadata column) {
        Type type = column.getType();
        Object step = PropertyValues.propertyValue(column, "step");
        if (step == null) {
            return ValueSet.none((Type)type);
        }
        if (FakerColumnHandle.isCharacterColumn(column)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property cannot be set for CHAR, VARCHAR or VARBINARY columns".formatted("step"));
        }
        Type stepType = type;
        if (DateType.DATE.equals((Object)type) || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type instanceof TimeType || type instanceof TimeWithTimeZoneType) {
            stepType = BigintType.BIGINT;
        }
        return ValueSet.of((Type)stepType, (Object)step, (Object[])new Object[0]);
    }

    private static Range range(Type type, Object min, Object max) {
        Objects.requireNonNull(type, "type is null");
        if (min == null && max == null) {
            return Range.all((Type)type);
        }
        if (max == null) {
            return Range.greaterThanOrEqual((Type)type, (Object)min);
        }
        if (min == null) {
            return Range.lessThanOrEqual((Type)type, (Object)max);
        }
        return Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true);
    }

    public FakerColumnHandle withNullProbability(double nullProbability) {
        return new FakerColumnHandle(this.columnIndex, this.name, this.type, nullProbability, this.generator, this.domain, this.step);
    }

    public FakerColumnHandle withDomain(Domain domain) {
        return new FakerColumnHandle(this.columnIndex, this.name, this.type, this.nullProbability, this.generator, domain, this.step);
    }

    public FakerColumnHandle withStep(ValueSet step) {
        return new FakerColumnHandle(this.columnIndex, this.name, this.type, this.nullProbability, this.generator, this.domain, step);
    }
}

