/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.faker.FakerColumnHandle;
import io.trino.plugin.faker.FakerConfig;
import io.trino.plugin.faker.FakerPageSource;
import io.trino.plugin.faker.FakerSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.random.RandomGenerator;
import java.util.random.RandomGeneratorFactory;
import net.datafaker.Faker;

public class FakerPageSourceProvider
implements ConnectorPageSourceProvider {
    private final Locale locale;
    private final RandomGenerator.JumpableGenerator jumpableRandom;
    private final Faker faker;

    @Inject
    public FakerPageSourceProvider(FakerConfig config) {
        this.locale = config.getLocale();
        this.jumpableRandom = (RandomGenerator.JumpableGenerator)RandomGeneratorFactory.of("Xoroshiro128PlusPlus").create(1L);
        this.faker = new Faker(this.locale, Random.from(this.jumpableRandom.copy()));
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        List handles = (List)columns.stream().map(FakerColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        FakerSplit fakerSplit = (FakerSplit)split;
        Random random = this.random(fakerSplit.splitNumber());
        return new FakerPageSource(new Faker(this.locale, random), random, handles, fakerSplit.rowsOffset(), fakerSplit.rowsCount());
    }

    private Random random(long index) {
        RandomGenerator.JumpableGenerator jumpableRandom = this.jumpableRandom.copy();
        for (long i = 0L; i < index; ++i) {
            jumpableRandom.jump();
        }
        return Random.from(jumpableRandom);
    }

    public void validateGenerator(String generator) {
        this.faker.expression(generator);
    }
}

