/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.URIStatus;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AlluxioFileIterator
implements FileIterator {
    private final Iterator<URIStatus> files;
    private final String basePath;

    public AlluxioFileIterator(List<URIStatus> files, String basePath) {
        this.files = Objects.requireNonNull(files.iterator(), "files is null");
        this.basePath = Objects.requireNonNull(basePath, "basePath is null");
    }

    public boolean hasNext() throws IOException {
        return this.files.hasNext();
    }

    public FileEntry next() throws IOException {
        if (!this.hasNext()) {
            return null;
        }
        URIStatus fileStatus = this.files.next();
        String filePath = fileStatus.getPath();
        Location location = Location.of((String)(this.basePath + filePath));
        return new FileEntry(location, fileStatus.getLength(), Instant.ofEpochMilli(fileStatus.getLastModificationTimeMs()), Optional.empty());
    }
}

