/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.FileInStream;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import java.io.IOException;
import java.util.Objects;

public class AlluxioFileSystemInput
implements TrinoInput {
    private final FileInStream stream;
    private final TrinoInputFile inputFile;
    private volatile boolean closed;

    public AlluxioFileSystemInput(FileInStream stream, TrinoInputFile inputFile) {
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.inputFile = Objects.requireNonNull(inputFile, "inputFile is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        if (position + (long)bufferLength > this.inputFile.length()) {
            throw new IOException("readFully position overflow %s. pos %d + buffer length %d > file size %d".formatted(this.inputFile.location(), position, bufferLength, this.inputFile.length()));
        }
        this.stream.positionedRead(position, buffer, bufferOffset, bufferLength);
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        long fileSize = this.inputFile.length();
        int readSize = (int)Math.min(fileSize, (long)bufferLength);
        this.readFully(fileSize - (long)readSize, buffer, bufferOffset, readSize);
        return readSize;
    }

    public String toString() {
        return this.inputFile.toString();
    }

    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed: " + String.valueOf(this));
        }
    }
}

