/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.FileInStream;
import alluxio.client.file.URIStatus;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInputStream;
import java.io.IOException;
import java.util.Objects;

public final class AlluxioTrinoInputStream
extends TrinoInputStream {
    private final Location location;
    private final FileInStream stream;
    private final URIStatus fileStatus;
    private boolean closed;

    public AlluxioTrinoInputStream(Location location, FileInStream stream, URIStatus fileStatus) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.stream = Objects.requireNonNull(stream, "stream is null");
        this.fileStatus = Objects.requireNonNull(fileStatus, "fileStatus is null");
    }

    public long getPosition() throws IOException {
        this.ensureOpen();
        try {
            return this.stream.getPos();
        }
        catch (IOException e) {
            throw new IOException("Get position for file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public void seek(long position) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (position > this.fileStatus.getLength()) {
            throw new IOException("Cannot seek to %s. File size is %s: %s".formatted(position, this.fileStatus.getLength(), this.location));
        }
        try {
            this.stream.seek(position);
        }
        catch (IOException e) {
            throw new IOException("Cannot seek to %s: %s".formatted(position, this.location));
        }
    }

    public long skip(long n) throws IOException {
        this.ensureOpen();
        try {
            return this.stream.skip(n);
        }
        catch (IOException e) {
            throw new IOException("Skipping %s bytes of file %s failed: %s".formatted(n, this.location, e.getMessage()), e);
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        try {
            return this.stream.read();
        }
        catch (IOException e) {
            throw new IOException("Read of file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(off, len, b.length);
        try {
            return this.stream.read(b, off, len);
        }
        catch (IOException e) {
            throw new IOException("Read of file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed: " + String.valueOf(this.location));
        }
    }

    public int available() throws IOException {
        this.ensureOpen();
        return super.available();
    }
}

